/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.data.custom.stalactites.entry.StalactiteReloadListener;

public abstract class StalactiteProvider
implements DataProvider {
    private final PackOutput generator;
    private final String modid;
    private final PackOutput.PathProvider entryPath;
    protected final Map<Pair<ResourceLocation, Stalactite>, Stalactite.HollowHillType> builder = Maps.newLinkedHashMap();

    public StalactiteProvider(PackOutput generator, String modid) {
        this.generator = generator;
        this.modid = modid;
        this.entryPath = generator.m_245269_(PackOutput.Target.DATA_PACK, "stalactites/entries");
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        HashMap map = Maps.newHashMap();
        HashMap smallHillEntries = Maps.newHashMap();
        HashMap medHillEntries = Maps.newHashMap();
        HashMap largeHillEntries = Maps.newHashMap();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.builder.clear();
        this.createStalactites();
        this.builder.forEach((stalactiteMap, type) -> {
            if (type == Stalactite.HollowHillType.LARGE) {
                largeHillEntries.put((ResourceLocation)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            } else if (type == Stalactite.HollowHillType.MEDIUM) {
                medHillEntries.put((ResourceLocation)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            } else {
                smallHillEntries.put((ResourceLocation)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            }
            map.put((ResourceLocation)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
        });
        map.forEach((resourceLocation, stalactite) -> {
            Path path = this.entryPath.m_245731_(resourceLocation);
            futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)output, (JsonElement)StalactiteReloadListener.serialize(stalactite), (Path)path));
        });
        Gson hillGson = new GsonBuilder().setPrettyPrinting().create();
        for (Stalactite.HollowHillType type2 : Stalactite.HollowHillType.values()) {
            Path hillPath = this.generator.m_245114_().resolve("data/twilightforest/stalactites/" + type2.name().toLowerCase(Locale.ROOT) + "_hollow_hill.json");
            HashMap mapToUse = type2 == Stalactite.HollowHillType.LARGE ? largeHillEntries : (type2 == Stalactite.HollowHillType.MEDIUM ? medHillEntries : smallHillEntries);
            JsonObject object = new JsonObject();
            object.addProperty("replace", Boolean.valueOf(false));
            object.add("stalactites", hillGson.toJsonTree(mapToUse.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList())));
            futuresBuilder.add((Object)DataProvider.m_253162_((CachedOutput)output, (JsonElement)object, (Path)hillPath));
        }
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    protected abstract void createStalactites();

    protected void makeStalactite(Stalactite stalactite, Stalactite.HollowHillType type) {
        Object name = "";
        for (Map.Entry<Block, Integer> entry : stalactite.ores().entrySet()) {
            name = (String)name + ForgeRegistries.BLOCKS.getKey((Object)entry.getKey()).m_135815_() + "_";
        }
        this.builder.putIfAbsent((Pair<ResourceLocation, Stalactite>)Pair.of((Object)new ResourceLocation(this.modid, (String)name + "stalactite"), (Object)stalactite), type);
    }

    public String m_6055_() {
        return this.modid + " Hollow Hill Stalactites";
    }
}

