/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.projectile.LichBolt;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.init.TFDamageSources;
import twilightforest.init.TFEntities;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class LichBomb
extends TFThrowable
implements ItemSupplier {
    public LichBomb(EntityType<? extends LichBomb> type, Level world) {
        super(type, world);
    }

    public LichBomb(Level world, LivingEntity thrower) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.LICH_BOMB.get()), world, thrower);
    }

    public void m_8119_() {
        super.m_8119_();
        this.makeTrail();
    }

    private void makeTrail() {
        for (int i = 0; i < 1; ++i) {
            double sx = 0.5 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) + this.m_20184_().m_7096_();
            double sy = 0.5 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) + this.m_20184_().m_7098_();
            double sz = 0.5 * (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) + this.m_20184_().m_7094_();
            double dx = this.m_20185_() + sx;
            double dy = this.m_20186_() + sy;
            double dz = this.m_20189_() + sz;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, dx, dy, dz, sx * -0.25, sy * -0.25, sz * -0.25);
        }
    }

    public boolean m_6060_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        super.m_6469_(source, amount);
        if (source.m_7640_() != null) {
            if (!source.m_19372_()) {
                this.explode();
            }
            return true;
        }
        return false;
    }

    private void explode() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_254877_((Entity)this, TFDamageSources.LICH_BOMB, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, false, Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    protected float m_7139_() {
        return 0.001f;
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.explode();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (result.m_82443_() instanceof LichBolt || result.m_82443_() instanceof LichBomb || result.m_82443_() instanceof Lich) {
            return;
        }
        this.explode();
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Items.f_42542_);
    }
}

