/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.KeepsakeCasketBlock;
import twilightforest.block.entity.KeepsakeCasketBlockEntity;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.entity.CharmEffect;
import twilightforest.enums.BlockLoggingEnum;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.util.TFItemStackUtils;

@Mod.EventBusSubscriber(modid="twilightforest")
public class CharmEvents {
    public static final String CHARM_INV_TAG = "TFCharmInventory";
    private static boolean casketExpiration = false;
    public static ItemStack charmUsed;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void applyDeathItems(LivingDeathEvent event) {
        Player player;
        LivingEntity living;
        block7: {
            block6: {
                living = event.getEntity();
                if (living.m_9236_().m_5776_() || !(living instanceof Player)) break block6;
                player = (Player)living;
                if (!(living instanceof FakePlayer) && !player.m_7500_() && !player.m_5833_()) break block7;
            }
            return;
        }
        if (CharmEvents.charmOfLife(player)) {
            event.setCanceled(true);
        } else if (!living.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            CharmEvents.charmOfKeeping(player);
            CharmEvents.keepsakeCasket(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!event.isEndConquered()) {
            if (casketExpiration) {
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"block.twilightforest.casket.broken").m_130940_(ChatFormatting.RED));
                casketExpiration = false;
            }
            CharmEvents.returnStoredItems((Player)serverPlayer);
        }
    }

    private static boolean charmOfLife(Player player) {
        boolean charm1;
        boolean charm2 = TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_LIFE_2.get()) || CharmEvents.hasCharmCurio((Item)TFItems.CHARM_OF_LIFE_2.get(), player);
        boolean bl = charm1 = !charm2 && (TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_LIFE_1.get()) || CharmEvents.hasCharmCurio((Item)TFItems.CHARM_OF_LIFE_1.get(), player));
        if (charm2 || charm1) {
            if (charm1) {
                player.m_21153_(8.0f);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0));
            }
            if (charm2) {
                player.m_21153_(player.m_21233_());
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 600, 3));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 600, 0));
            }
            CharmEffect effect = new CharmEffect((EntityType<? extends CharmEffect>)((EntityType)TFEntities.CHARM_EFFECT.get()), player.m_9236_(), (LivingEntity)player, charm1 ? (Item)TFItems.CHARM_OF_LIFE_1.get() : (Item)TFItems.CHARM_OF_LIFE_2.get());
            player.m_9236_().m_7967_((Entity)effect);
            CharmEffect effect2 = new CharmEffect((EntityType<? extends CharmEffect>)((EntityType)TFEntities.CHARM_EFFECT.get()), player.m_9236_(), (LivingEntity)player, charm1 ? (Item)TFItems.CHARM_OF_LIFE_1.get() : (Item)TFItems.CHARM_OF_LIFE_2.get());
            effect2.offset = (float)Math.PI;
            player.m_9236_().m_7967_((Entity)effect2);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)TFSounds.CHARM_LIFE.get(), player.m_5720_(), 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                player.m_36220_((ResourceLocation)TFStats.LIFE_CHARMS_ACTIVATED.get());
            }
            return true;
        }
        return false;
    }

    private static void charmOfKeeping(Player player) {
        int i;
        boolean tier3 = TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_KEEPING_3.get()) || CharmEvents.hasCharmCurio((Item)TFItems.CHARM_OF_KEEPING_3.get(), player);
        boolean tier2 = tier3 || TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_KEEPING_2.get()) || CharmEvents.hasCharmCurio((Item)TFItems.CHARM_OF_KEEPING_2.get(), player);
        boolean tier1 = tier2 || TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_KEEPING_1.get()) || CharmEvents.hasCharmCurio((Item)TFItems.CHARM_OF_KEEPING_1.get(), player);
        Inventory keepInventory = new Inventory(null);
        ListTag tagList = new ListTag();
        if (tier1) {
            CharmEvents.keepWholeList((NonNullList<ItemStack>)keepInventory.f_35975_, (NonNullList<ItemStack>)player.m_150109_().f_35975_);
            CharmEvents.keepWholeList((NonNullList<ItemStack>)keepInventory.f_35976_, (NonNullList<ItemStack>)player.m_150109_().f_35976_);
        }
        if (tier3) {
            CharmEvents.keepWholeList((NonNullList<ItemStack>)keepInventory.f_35974_, (NonNullList<ItemStack>)player.m_150109_().f_35974_);
            charmUsed = new ItemStack((ItemLike)TFItems.CHARM_OF_KEEPING_3.get());
        } else if (tier2) {
            for (i = 0; i < 9; ++i) {
                keepInventory.f_35974_.set(i, (Object)((ItemStack)player.m_150109_().f_35974_.get(i)).m_41777_());
                player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
            }
            charmUsed = new ItemStack((ItemLike)TFItems.CHARM_OF_KEEPING_2.get());
        } else if (tier1) {
            i = player.m_150109_().f_35977_;
            if (Inventory.m_36045_((int)i)) {
                keepInventory.f_35974_.set(i, (Object)((ItemStack)player.m_150109_().f_35974_.get(i)).m_41777_());
                player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
            }
            charmUsed = new ItemStack((ItemLike)TFItems.CHARM_OF_KEEPING_1.get());
        }
        for (i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (!stack.m_204117_(ItemTagGenerator.KEPT_ON_DEATH)) continue;
            keepInventory.f_35974_.set(i, (Object)stack.m_41777_());
            player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
        }
        for (i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            ItemStack armor = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (!armor.m_204117_(ItemTagGenerator.KEPT_ON_DEATH)) continue;
            keepInventory.f_35975_.set(i, (Object)armor.m_41777_());
            player.m_150109_().f_35975_.set(i, (Object)ItemStack.f_41583_);
        }
        if (((ItemStack)player.m_150109_().f_35976_.get(0)).m_204117_(ItemTagGenerator.KEPT_ON_DEATH)) {
            keepInventory.f_35976_.set(0, (Object)((ItemStack)player.m_150109_().f_35976_.get(0)).m_41777_());
            player.m_150109_().f_35976_.set(0, (Object)ItemStack.f_41583_);
        }
        if (!keepInventory.m_7983_()) {
            keepInventory.m_36026_(tagList);
            CharmEvents.getPlayerData(player).m_128365_(CHARM_INV_TAG, (Tag)tagList);
        }
    }

    private static void keepsakeCasket(Player player) {
        TFItemStackUtils.damage = 0;
        boolean casketConsumed = TFItemStackUtils.consumeInventoryItem(player, ((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).m_5456_());
        if (casketConsumed) {
            Level level = player.m_20193_();
            BlockPos.MutableBlockPos pos = player.m_20183_().m_122032_();
            if (pos.m_123342_() < level.m_6042_().f_156647_() + 2) {
                pos.m_142448_(level.m_6042_().f_156647_() + 2);
            } else {
                int logicalHeight = player.m_20193_().m_6042_().f_63865_();
                if (pos.m_123342_() > logicalHeight) {
                    pos.m_142448_(logicalHeight - 1);
                }
            }
            pos.m_122184_(0, -1, 0);
            do {
                pos.m_122184_(0, 1, 0);
            } while (!level.m_8055_((BlockPos)pos).m_60767_().m_76336_());
            BlockPos immutablePos = pos.m_7949_();
            FluidState fluidState = level.m_6425_(immutablePos);
            if (level.m_46597_(immutablePos, (BlockState)((BlockState)((BlockState)((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).m_49966_().m_61124_(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.m_76152_())))).m_61124_((Property)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(TFItemStackUtils.damage))).m_61124_((Property)KeepsakeCasketBlock.FACING, (Comparable)Direction.m_122407_((int)level.m_213780_().m_188503_(3))))) {
                BlockEntity te = level.m_7702_(immutablePos);
                if (te instanceof KeepsakeCasketBlockEntity) {
                    KeepsakeCasketBlockEntity casket = (KeepsakeCasketBlockEntity)te;
                    casket.playeruuid = (Boolean)TFConfig.COMMON_CONFIG.casketUUIDLocking.get() != false ? player.m_36316_().getId() : null;
                    String modifiedName = player.m_7755_().getString().length() > 12 ? player.m_7755_().getString().substring(0, 12) : player.m_7755_().getString();
                    casket.f_58622_ = player.m_7755_().getString();
                    casket.casketname = modifiedName;
                    casket.m_58638_((Component)Component.m_237113_((String)(modifiedName + "'s " + (level.m_213780_().m_188503_(1000) == 0 ? "Costco Casket" : casket.m_5446_().getString()))));
                    int damage = (Integer)level.m_8055_(immutablePos).m_61143_((Property)KeepsakeCasketBlock.BREAKAGE);
                    if (level.m_213780_().m_188501_() <= 0.15f) {
                        if (damage >= 2) {
                            player.m_150109_().m_36071_();
                            level.m_46597_(immutablePos, Blocks.f_50016_.m_49966_());
                            casketExpiration = true;
                            TwilightForestMod.LOGGER.debug("{}'s Casket damage value was too high, alerting the player and dropping extra items", (Object)player.m_7755_().getString());
                        } else {
                            level.m_46597_(immutablePos, (BlockState)((BlockState)((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).m_49966_().m_61124_(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.m_76152_())))).m_61124_((Property)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(++damage)));
                            TwilightForestMod.LOGGER.debug("{}'s Casket was randomly damaged, applying new damage", (Object)player.m_7755_().getString());
                        }
                    }
                    int casketCapacity = casket.m_6643_();
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>(casketCapacity);
                    NonNullList filler = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
                    list.addAll((Collection<ItemStack>)TFItemStackUtils.sortArmorForCasket(player));
                    player.m_150109_().f_35975_.clear();
                    list.addAll((Collection<ItemStack>)filler);
                    list.addAll((Collection<ItemStack>)player.m_150109_().f_35976_);
                    player.m_150109_().f_35976_.clear();
                    list.addAll((Collection<ItemStack>)TFItemStackUtils.sortInvForCasket(player));
                    player.m_150109_().f_35974_.clear();
                    casket.m_6520_((NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])list.toArray(new ItemStack[casketCapacity])));
                }
            } else {
                TwilightForestMod.LOGGER.error("Could not place Keepsake Casket at " + pos);
            }
        }
    }

    private static void returnStoredItems(Player player) {
        TwilightForestMod.LOGGER.debug("Player {} ({}) respawned and received items held in storage", (Object)player.m_7755_().getString(), (Object)player.m_20148_());
        CompoundTag playerData = CharmEvents.getPlayerData(player);
        if (!player.m_9236_().m_5776_() && playerData.m_128441_(CHARM_INV_TAG)) {
            ListTag tagList = playerData.m_128437_(CHARM_INV_TAG, 10);
            TFItemStackUtils.loadNoClear(tagList, player.m_150109_());
            CharmEvents.getPlayerData(player).m_128437_(CHARM_INV_TAG, 10).clear();
            CharmEvents.getPlayerData(player).m_128473_(CHARM_INV_TAG);
        }
        if (charmUsed != null) {
            CharmEffect effect = new CharmEffect((EntityType<? extends CharmEffect>)((EntityType)TFEntities.CHARM_EFFECT.get()), player.m_9236_(), (LivingEntity)player, charmUsed.m_41720_());
            player.m_9236_().m_7967_((Entity)effect);
            CharmEffect effect2 = new CharmEffect((EntityType<? extends CharmEffect>)((EntityType)TFEntities.CHARM_EFFECT.get()), player.m_9236_(), (LivingEntity)player, charmUsed.m_41720_());
            effect2.offset = (float)Math.PI;
            player.m_9236_().m_7967_((Entity)effect2);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)TFSounds.CHARM_KEEP.get(), player.m_5720_(), 1.5f, 1.0f);
            if (player instanceof ServerPlayer) {
                player.m_36220_((ResourceLocation)TFStats.KEEPING_CHARMS_ACTIVATED.get());
            }
            charmUsed = null;
        }
    }

    public static CompoundTag getPlayerData(Player player) {
        if (!player.getPersistentData().m_128441_("PlayerPersisted")) {
            player.getPersistentData().m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        return player.getPersistentData().m_128469_("PlayerPersisted");
    }

    private static void keepWholeList(NonNullList<ItemStack> transferTo, NonNullList<ItemStack> transferFrom) {
        for (int i = 0; i < transferFrom.size(); ++i) {
            transferTo.set(i, (Object)((ItemStack)transferFrom.get(i)).m_41777_());
        }
        transferFrom.clear();
    }

    private static boolean hasCharmCurio(Item item, Player player) {
        if (ModList.get().isLoaded("curios")) {
            // empty if block
        }
        return false;
    }
}

