/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import twilightforest.TwilightForestMod;

public class TFLootTables {
    private static final Set<ResourceLocation> TF_LOOT_TABLES = Sets.newHashSet();
    private static final int DEFAULT_PLACE_FLAG = 2;
    public static final TFLootTables SMALL_HOLLOW_HILL = new TFLootTables("hill_1");
    public static final TFLootTables MEDIUM_HOLLOW_HILL = new TFLootTables("hill_2");
    public static final TFLootTables LARGE_HOLLOW_HILL = new TFLootTables("hill_3");
    public static final TFLootTables HEDGE_MAZE = new TFLootTables("hedge_maze");
    public static final TFLootTables FANCY_WELL = new TFLootTables("fancy_well");
    public static final TFLootTables WELL = new TFLootTables("well");
    public static final TFLootTables LABYRINTH_ROOM = new TFLootTables("labyrinth_room");
    public static final TFLootTables LABYRINTH_DEAD_END = new TFLootTables("labyrinth_dead_end");
    public static final TFLootTables TOWER_ROOM = new TFLootTables("tower_room");
    public static final TFLootTables TOWER_LIBRARY = new TFLootTables("tower_library");
    public static final TFLootTables BASEMENT = new TFLootTables("basement");
    public static final TFLootTables FOUNDATION_BASEMENT = new TFLootTables("foundation_basement");
    public static final TFLootTables LABYRINTH_VAULT = new TFLootTables("labyrinth_vault");
    public static final TFLootTables LABYRINTH_VAULT_JACKPOT = new TFLootTables("labyrinth_vault_jackpot");
    public static final TFLootTables DARKTOWER_CACHE = new TFLootTables("darktower_cache");
    public static final TFLootTables DARKTOWER_KEY = new TFLootTables("darktower_key");
    public static final TFLootTables DARKTOWER_BOSS = new TFLootTables("darktower_boss");
    public static final TFLootTables TREE_CACHE = new TFLootTables("tree_cache");
    public static final TFLootTables STRONGHOLD_CACHE = new TFLootTables("stronghold_cache");
    public static final TFLootTables STRONGHOLD_ROOM = new TFLootTables("stronghold_room");
    public static final TFLootTables STRONGHOLD_BOSS = new TFLootTables("stronghold_boss");
    public static final TFLootTables AURORA_CACHE = new TFLootTables("aurora_cache");
    public static final TFLootTables AURORA_ROOM = new TFLootTables("aurora_room");
    public static final TFLootTables TROLL_GARDEN = new TFLootTables("troll_garden");
    public static final TFLootTables TROLL_VAULT = new TFLootTables("troll_vault");
    public static final TFLootTables TROLL_VAULT_WITH_LAMP = new TFLootTables("troll_vault_with_lamp");
    public static final TFLootTables GRAVEYARD = new TFLootTables("graveyard");
    public static final TFLootTables QUEST_GROVE = new TFLootTables("quest_grove_dropper");
    public static final TFLootTables USELESS_LOOT = new TFLootTables("useless");
    public static final ResourceLocation BIGHORN_SHEEP_WHITE = TFLootTables.register("entities/bighorn_sheep/white");
    public static final ResourceLocation BIGHORN_SHEEP_ORANGE = TFLootTables.register("entities/bighorn_sheep/orange");
    public static final ResourceLocation BIGHORN_SHEEP_MAGENTA = TFLootTables.register("entities/bighorn_sheep/magenta");
    public static final ResourceLocation BIGHORN_SHEEP_LIGHT_BLUE = TFLootTables.register("entities/bighorn_sheep/light_blue");
    public static final ResourceLocation BIGHORN_SHEEP_YELLOW = TFLootTables.register("entities/bighorn_sheep/yellow");
    public static final ResourceLocation BIGHORN_SHEEP_LIME = TFLootTables.register("entities/bighorn_sheep/lime");
    public static final ResourceLocation BIGHORN_SHEEP_PINK = TFLootTables.register("entities/bighorn_sheep/pink");
    public static final ResourceLocation BIGHORN_SHEEP_GRAY = TFLootTables.register("entities/bighorn_sheep/gray");
    public static final ResourceLocation BIGHORN_SHEEP_LIGHT_GRAY = TFLootTables.register("entities/bighorn_sheep/light_gray");
    public static final ResourceLocation BIGHORN_SHEEP_CYAN = TFLootTables.register("entities/bighorn_sheep/cyan");
    public static final ResourceLocation BIGHORN_SHEEP_PURPLE = TFLootTables.register("entities/bighorn_sheep/purple");
    public static final ResourceLocation BIGHORN_SHEEP_BLUE = TFLootTables.register("entities/bighorn_sheep/blue");
    public static final ResourceLocation BIGHORN_SHEEP_BROWN = TFLootTables.register("entities/bighorn_sheep/brown");
    public static final ResourceLocation BIGHORN_SHEEP_GREEN = TFLootTables.register("entities/bighorn_sheep/green");
    public static final ResourceLocation BIGHORN_SHEEP_RED = TFLootTables.register("entities/bighorn_sheep/red");
    public static final ResourceLocation BIGHORN_SHEEP_BLACK = TFLootTables.register("entities/bighorn_sheep/black");
    public static final ResourceLocation QUESTING_RAM_REWARDS = TFLootTables.register("entities/questing_ram_rewards");
    public static final ResourceLocation DEATH_TOME_HURT = TFLootTables.register("entities/death_tome_hurt");
    public static final ResourceLocation DEATH_TOME_BOOKS = TFLootTables.register("entities/death_tome_books");
    public static final ResourceLocation CICADA_SQUISH_DROPS = TFLootTables.register("blocks/cicada_squish");
    public static final ResourceLocation FIREFLY_SQUISH_DROPS = TFLootTables.register("blocks/firefly_squish");
    public static final ResourceLocation MOONWORM_SQUISH_DROPS = TFLootTables.register("blocks/moonworm_squish");
    public final ResourceLocation lootTable;

    private TFLootTables(String path) {
        this.lootTable = TwilightForestMod.prefix(String.format("chests/%s", path));
    }

    public void generateChest(WorldGenLevel world, BlockPos pos, Direction dir, boolean trapped) {
        this.generateLootContainer(world, pos, (BlockState)(trapped ? Blocks.f_50325_ : Blocks.f_50087_).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)dir), 2);
    }

    public void generateLootContainer(WorldGenLevel world, BlockPos pos, BlockState state, int flags) {
        world.m_7731_(pos, state, flags);
        this.generateChestContents(world, pos);
    }

    public void generateLootContainer(LevelAccessor world, BlockPos pos, BlockState state, int flags, long seed) {
        world.m_7731_(pos, state, flags);
        this.generateChestContents(world, pos, seed);
    }

    public void generateChestContents(WorldGenLevel world, BlockPos pos) {
        this.generateChestContents((LevelAccessor)world, pos, world.m_7328_() * (long)pos.m_123341_() + (long)pos.m_123342_() ^ (long)pos.m_123343_());
    }

    public void generateChestContents(LevelAccessor world, BlockPos pos, long seed) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity lootContainer = (RandomizableContainerBlockEntity)blockEntity;
            lootContainer.m_59626_(this.lootTable, seed);
        }
    }

    private static ResourceLocation register(String id) {
        return TFLootTables.register(TwilightForestMod.prefix(id));
    }

    private static ResourceLocation register(ResourceLocation id) {
        if (TF_LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(id + " is already a registered built-in loot table");
    }

    public static void entityDropsIntoContainer(LivingEntity entity, LootContext lootContext, BlockState blockContaining, BlockPos placement) {
        ServerLevel serverLevel;
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_7731_(placement, blockContaining, 2) && (level = serverLevel.m_7702_(placement)) instanceof Container) {
            Container container = (Container)level;
            LootTable table = serverLevel.m_7654_().m_129898_().m_79217_(entity.m_5743_());
            ObjectArrayList stacks = table.m_230922_(lootContext);
            table.m_79123_(container, lootContext);
            if (stacks.size() > 27) {
                for (ItemStack stack : stacks.subList(28, stacks.size())) {
                    ItemEntity item = new ItemEntity((Level)serverLevel, (double)placement.m_7494_().m_123341_(), (double)placement.m_7494_().m_123342_(), (double)placement.m_7494_().m_123343_(), stack);
                    item.m_32064_();
                    item.m_32061_();
                    serverLevel.m_7967_((Entity)item);
                }
            }
        }
    }

    public static Set<ResourceLocation> allBuiltin() {
        return Collections.unmodifiableSet(TF_LOOT_TABLES);
    }
}

