/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.util.Vec2i;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorWrapper;
import twilightforest.world.components.chunkgenerators.warp.NoiseModifier;
import twilightforest.world.components.chunkgenerators.warp.NoiseSlider;
import twilightforest.world.components.chunkgenerators.warp.TFBlendedNoise;
import twilightforest.world.components.chunkgenerators.warp.TFNoiseInterpolator;
import twilightforest.world.components.chunkgenerators.warp.TFTerrainWarp;
import twilightforest.world.components.structures.TFStructureComponent;
import twilightforest.world.components.structures.placements.BiomeForcedLandmarkPlacement;
import twilightforest.world.components.structures.start.LegacyLandmark;
import twilightforest.world.components.structures.start.TFStructureStart;

public class ChunkGeneratorTwilight
extends ChunkGeneratorWrapper {
    public static final Codec<ChunkGeneratorTwilight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChunkGenerator.f_62136_.fieldOf("wrapped_generator").forGetter(o -> o.delegate), (App)NoiseGeneratorSettings.f_64431_.fieldOf("noise_generation_settings").forGetter(o -> o.noiseGeneratorSettings), (App)Codec.BOOL.fieldOf("generate_dark_forest_canopy").forGetter(o -> o.genDarkForestCanopy), (App)Codec.INT.optionalFieldOf("dark_forest_canopy_height").forGetter(o -> o.darkForestCanopyHeight), (App)Codec.unboundedMap((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_), (Codec)TFLandmark.CODEC.listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf)).fieldOf("landmark_placement_allowed_biomes").forGetter(o -> o.biomeLandmarkOverrides)).apply((Applicative)instance, ChunkGeneratorTwilight::new));
    private final Map<ResourceKey<Biome>, ImmutableSet<TFLandmark>> biomeLandmarkOverrides;
    private final Holder<NoiseGeneratorSettings> noiseGeneratorSettings;
    private final boolean genDarkForestCanopy;
    private final Optional<Integer> darkForestCanopyHeight;
    private final BlockState defaultBlock;
    private final BlockState defaultFluid;
    private final Optional<Climate.Sampler> surfaceNoiseGetter;
    private final Optional<TFTerrainWarp> warper;
    private static final BlockState[] EMPTY_COLUMN = new BlockState[0];

    public ChunkGeneratorTwilight(ChunkGenerator delegate, Holder<NoiseGeneratorSettings> noiseGenSettings, boolean genDarkForestCanopy, Optional<Integer> darkForestCanopyHeight, Map<ResourceKey<Biome>, ImmutableSet<TFLandmark>> biomeLandmarkOverrides) {
        super(delegate);
        NoiseBasedChunkGenerator noiseGen;
        this.biomeLandmarkOverrides = biomeLandmarkOverrides;
        this.noiseGeneratorSettings = noiseGenSettings;
        this.genDarkForestCanopy = genDarkForestCanopy;
        this.darkForestCanopyHeight = darkForestCanopyHeight;
        if (delegate instanceof NoiseBasedChunkGenerator && (noiseGen = (NoiseBasedChunkGenerator)delegate).m_224341_().m_203633_()) {
            this.defaultBlock = ((NoiseGeneratorSettings)noiseGen.m_224341_().get()).f_64440_();
            this.defaultFluid = ((NoiseGeneratorSettings)noiseGen.m_224341_().get()).f_64441_();
            this.surfaceNoiseGetter = Optional.empty();
        } else {
            this.defaultBlock = Blocks.f_50069_.m_49966_();
            this.defaultFluid = Blocks.f_49990_.m_49966_();
            this.surfaceNoiseGetter = Optional.empty();
        }
        if (noiseGenSettings.m_203633_()) {
            NoiseSettings settings = ((NoiseGeneratorSettings)noiseGenSettings.m_203334_()).f_64439_();
            BiomeSource biomeSource = delegate.m_62218_();
            if (biomeSource instanceof TFBiomeProvider) {
                TFBiomeProvider source = (TFBiomeProvider)biomeSource;
                WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
                TFBlendedNoise blendedNoise = new TFBlendedNoise((RandomSource)random);
                NoiseModifier modifier = NoiseModifier.PASS;
                this.warper = Optional.of(new TFTerrainWarp(settings.m_189213_(), settings.m_189212_(), settings.f_64508_() / settings.m_189212_(), source, new NoiseSlider(-10.0, 3, 0), new NoiseSlider(15.0, 3, 0), settings, blendedNoise, modifier));
            } else {
                this.warper = Optional.empty();
            }
        } else {
            this.warper = Optional.empty();
        }
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    @Override
    public int m_214096_(int x, int z, Heightmap.Types heightMap, LevelHeightAccessor level, RandomState random) {
        if (this.warper.isEmpty()) {
            return super.m_214096_(x, z, heightMap, level, random);
        }
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int minY = Math.max(settings.f_158688_(), level.m_141937_());
        int maxY = Math.min(settings.f_158688_() + settings.f_64508_(), level.m_151558_());
        int minCell = Mth.m_14042_((int)minY, (int)settings.m_189212_());
        int maxCell = Mth.m_14042_((int)(maxY - minY), (int)settings.m_189212_());
        return maxCell <= 0 ? level.m_141937_() : this.iterateNoiseColumn(random, x, z, null, heightMap.m_64299_(), minCell, maxCell).orElse(level.m_141937_());
    }

    @Override
    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor level, RandomState random) {
        if (this.warper.isEmpty()) {
            return super.m_214184_(x, z, level, random);
        }
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int minY = Math.max(settings.f_158688_(), level.m_141937_());
        int maxY = Math.min(settings.f_158688_() + settings.f_64508_(), level.m_151558_());
        int minCell = Mth.m_14042_((int)minY, (int)settings.m_189212_());
        int maxCell = Mth.m_14042_((int)(maxY - minY), (int)settings.m_189212_());
        if (maxCell <= 0) {
            return new NoiseColumn(minY, EMPTY_COLUMN);
        }
        BlockState[] ablockstate = new BlockState[maxCell * settings.m_189212_()];
        this.iterateNoiseColumn(random, x, z, ablockstate, null, minCell, maxCell);
        return new NoiseColumn(minY, ablockstate);
    }

    protected OptionalInt iterateNoiseColumn(RandomState random, int x, int z, BlockState[] states, @Nullable Predicate<BlockState> predicate, int min, int max) {
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int cellWidth = settings.m_189213_();
        int cellHeight = settings.m_189212_();
        int xDiv = Math.floorDiv(x, cellWidth);
        int zDiv = Math.floorDiv(z, cellWidth);
        int xMod = Math.floorMod(x, cellWidth);
        int zMod = Math.floorMod(z, cellWidth);
        int xMin = xMod / cellWidth;
        int zMin = zMod / cellWidth;
        double[][] columns = new double[][]{this.makeAndFillNoiseColumn(random, xDiv, zDiv, min, max), this.makeAndFillNoiseColumn(random, xDiv, zDiv + 1, min, max), this.makeAndFillNoiseColumn(random, xDiv + 1, zDiv, min, max), this.makeAndFillNoiseColumn(random, xDiv + 1, zDiv + 1, min, max)};
        for (int cell = max - 1; cell >= 0; --cell) {
            double d00 = columns[0][cell];
            double d10 = columns[1][cell];
            double d20 = columns[2][cell];
            double d30 = columns[3][cell];
            double d01 = columns[0][cell + 1];
            double d11 = columns[1][cell + 1];
            double d21 = columns[2][cell + 1];
            double d31 = columns[3][cell + 1];
            for (int height = cellHeight - 1; height >= 0; --height) {
                double dcell = (double)height / (double)cellHeight;
                double lcell = Mth.m_14019_((double)dcell, (double)xMin, (double)zMin, (double)d00, (double)d01, (double)d20, (double)d21, (double)d10, (double)d11, (double)d30, (double)d31);
                int layer = cell * cellHeight + height;
                int maxlayer = layer + min * cellHeight;
                BlockState state = this.generateBaseState(lcell, layer);
                if (states != null) {
                    states[layer] = state;
                }
                if (predicate == null || !predicate.test(state)) continue;
                return OptionalInt.of(maxlayer + 1);
            }
        }
        return OptionalInt.empty();
    }

    public CompletableFuture<ChunkAccess> m_213908_(Executor executor, RandomState random, Blender blender, StructureManager manager, ChunkAccess chunkAccess) {
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"init_biomes", () -> {
            chunkAccess.m_183442_((BiomeResolver)this.m_62218_(), Climate.m_207841_());
            return chunkAccess;
        }), Util.m_183991_());
    }

    @Override
    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState random, StructureManager structureManager, ChunkAccess chunkAccess) {
        if (this.warper.isEmpty()) {
            return super.m_213974_(executor, blender, random, structureManager, chunkAccess);
        }
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int cellHeight = settings.m_189212_();
        int minY = Math.max(settings.f_158688_(), chunkAccess.m_141937_());
        int maxY = Math.min(settings.f_158688_() + settings.f_64508_(), chunkAccess.m_151558_());
        int mincell = Mth.m_14042_((int)minY, (int)cellHeight);
        int maxcell = Mth.m_14042_((int)(maxY - minY), (int)cellHeight);
        if (maxcell <= 0) {
            return CompletableFuture.completedFuture(chunkAccess);
        }
        int maxIndex = chunkAccess.m_151564_(maxcell * cellHeight - 1 + minY);
        int minIndex = chunkAccess.m_151564_(minY);
        HashSet sections = Sets.newHashSet();
        for (int index = maxIndex; index >= minIndex; --index) {
            LevelChunkSection section = chunkAccess.m_183278_(index);
            section.m_62981_();
            sections.add(section);
        }
        return CompletableFuture.supplyAsync(() -> this.doFill(random, chunkAccess, mincell, maxcell), Util.m_183991_()).whenCompleteAsync((chunk, throwable) -> {
            for (LevelChunkSection section : sections) {
                section.m_63006_();
            }
        }, executor);
    }

    private ChunkAccess doFill(RandomState random, ChunkAccess access, int min, int max) {
        NoiseSettings settings = ((NoiseGeneratorSettings)this.noiseGeneratorSettings.m_203334_()).f_64439_();
        int cellWidth = settings.m_189213_();
        int cellHeight = settings.m_189212_();
        int cellCountX = 16 / cellWidth;
        int cellCountZ = 16 / cellWidth;
        Heightmap oceanfloor = access.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap surface = access.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkpos = access.m_7697_();
        int minX = chunkpos.m_45604_();
        int minZ = chunkpos.m_45605_();
        TFNoiseInterpolator interpolator = new TFNoiseInterpolator(cellCountX, max, cellCountZ, chunkpos, min, (columns, x, z, min1, max1, max12) -> this.fillNoiseColumn(x, z, min1, max1, max12));
        ArrayList list = Lists.newArrayList((Object[])new TFNoiseInterpolator[]{interpolator});
        list.forEach(noiseint -> noiseint.initialiseFirstX(random));
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int cellX = 0; cellX < cellCountX; ++cellX) {
            int advX = cellX;
            list.forEach(noiseint -> noiseint.advanceX(random, advX));
            for (int cellZ = 0; cellZ < cellCountZ; ++cellZ) {
                LevelChunkSection section = access.m_183278_(access.m_151559_() - 1);
                for (int cellY = max - 1; cellY >= 0; --cellY) {
                    int advY = cellY;
                    int advZ = cellZ;
                    list.forEach(noiseint -> noiseint.selectYZ(advY, advZ));
                    for (int height = cellHeight - 1; height >= 0; --height) {
                        int minheight = (min + cellY) * cellHeight + height;
                        int mincellY = minheight & 0xF;
                        int minindexY = access.m_151564_(minheight);
                        if (access.m_151564_(section.m_63017_()) != minindexY) {
                            section = access.m_183278_(minindexY);
                        }
                        double heightdiv = (double)height / (double)cellHeight;
                        list.forEach(noiseint -> noiseint.updateY(heightdiv));
                        for (int widthX = 0; widthX < cellWidth; ++widthX) {
                            int minwidthX = minX + cellX * cellWidth + widthX;
                            int mincellX = minwidthX & 0xF;
                            double widthdivX = (double)widthX / (double)cellWidth;
                            list.forEach(noiseint -> noiseint.updateX(widthdivX));
                            for (int widthZ = 0; widthZ < cellWidth; ++widthZ) {
                                int minwidthZ = minZ + cellZ * cellWidth + widthZ;
                                int mincellZ = minwidthZ & 0xF;
                                double widthdivZ = (double)widthZ / (double)cellWidth;
                                double noiseval = interpolator.updateZ(widthdivZ);
                                BlockState state = this.generateBaseState(noiseval, minheight);
                                if (state == Blocks.f_50016_.m_49966_()) continue;
                                if (state.m_60791_() != 0 && access instanceof ProtoChunk) {
                                    ProtoChunk proto = (ProtoChunk)access;
                                    mutable.m_122178_(minwidthX, minheight, minwidthZ);
                                    proto.m_63277_((BlockPos)mutable);
                                }
                                section.m_62991_(mincellX, mincellY, mincellZ, state, false);
                                oceanfloor.m_64249_(mincellX, minheight, mincellZ, state);
                                surface.m_64249_(mincellX, minheight, mincellZ, state);
                            }
                        }
                    }
                }
            }
            list.forEach(TFNoiseInterpolator::swapSlices);
        }
        return access;
    }

    private double[] makeAndFillNoiseColumn(RandomState state, int x, int z, int min, int max) {
        double[] columns = new double[max + 1];
        this.fillNoiseColumn(columns, x, z, min, max);
        return columns;
    }

    private void fillNoiseColumn(double[] columns, int x, int z, int min, int max) {
        this.warper.get().fillNoiseColumn(columns, x, z, min, max);
    }

    private BlockState generateBaseState(double noiseVal, double level) {
        BlockState state = noiseVal > 0.0 ? this.defaultBlock : (level < (double)this.m_6337_() ? this.defaultFluid : Blocks.f_50016_.m_49966_());
        return state;
    }

    @Override
    public void m_214194_(WorldGenRegion world, StructureManager manager, RandomState random, ChunkAccess chunk) {
        this.deformTerrainForFeature(world, chunk);
        super.m_214194_(world, manager, random, chunk);
        this.darkForestCanopyHeight.ifPresent(integer -> this.addDarkForestCanopy(world, chunk, (int)integer));
        this.addGlaciers(world, chunk);
    }

    private void addGlaciers(WorldGenRegion primer, ChunkAccess chunk) {
        BlockState glacierBase = Blocks.f_49994_.m_49966_();
        BlockState glacierMain = Blocks.f_50354_.m_49966_();
        BlockState glacierTop = Blocks.f_50126_.m_49966_();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Optional biome = primer.m_204166_(primer.m_143488_().m_45615_().m_7918_(x, 0, z)).m_203543_();
                if (biome.isEmpty() || !TFBiomes.GLACIER.m_135782_().equals((Object)((ResourceKey)biome.get()).m_135782_())) continue;
                int gBase = -1;
                for (int y = 127; y >= 0; --y) {
                    Block currentBlock = primer.m_8055_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y)).m_60734_();
                    if (currentBlock != Blocks.f_50069_) continue;
                    gBase = y;
                    primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y), glacierBase, 3);
                    break;
                }
                int gHeight = 32;
                int gTop = Math.min(gBase + gHeight, 127);
                for (int y = gBase; y < gTop; ++y) {
                    primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y), glacierMain, 3);
                }
                primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), gTop), glacierTop, 3);
            }
        }
    }

    public void m_213600_(List<String> p_223175_, RandomState p_223176_, BlockPos p_223177_) {
    }

    protected final void deformTerrainForFeature(WorldGenRegion primer, ChunkAccess chunk) {
        Vec2i featureRelativePos = new Vec2i();
        TFLandmark nearFeature = LegacyLandmarkPlacements.getNearestLandmark(primer.m_143488_().f_45578_, primer.m_143488_().f_45579_, (WorldGenLevel)primer, featureRelativePos);
        if (!nearFeature.requiresTerraforming) {
            return;
        }
        int relativeFeatureX = featureRelativePos.x;
        int relativeFeatureZ = featureRelativePos.z;
        if (LegacyLandmarkPlacements.isTheseFeatures(nearFeature, TFLandmark.SMALL_HILL, TFLandmark.MEDIUM_HILL, TFLandmark.LARGE_HILL, TFLandmark.HYDRA_LAIR)) {
            int hdiam = (nearFeature.size * 2 + 1) * 16;
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                    int featureDX = xInChunk - relativeFeatureX;
                    int featureDZ = zInChunk - relativeFeatureZ;
                    float dist = (int)Mth.m_14116_((float)(featureDX * featureDX + featureDZ * featureDZ));
                    float hheight = (int)(Mth.m_14089_((float)(dist / (float)hdiam * (float)Math.PI)) * ((float)hdiam / 3.0f));
                    this.raiseHills(primer, chunk, nearFeature, hdiam, xInChunk, zInChunk, featureDX, featureDZ, hheight);
                }
            }
        } else if (nearFeature == TFLandmark.HEDGE_MAZE || nearFeature == TFLandmark.NAGA_COURTYARD || nearFeature == TFLandmark.QUEST_GROVE) {
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                    int featureDX = xInChunk - relativeFeatureX;
                    int featureDZ = zInChunk - relativeFeatureZ;
                    this.flattenTerrainForFeature(primer, nearFeature, xInChunk, zInChunk, featureDX, featureDZ);
                }
            }
        } else if (nearFeature == TFLandmark.YETI_CAVE) {
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                    int featureDX = xInChunk - relativeFeatureX;
                    int featureDZ = zInChunk - relativeFeatureZ;
                    this.deformTerrainForYetiLair(primer, nearFeature, xInChunk, zInChunk, featureDX, featureDZ);
                }
            }
        } else if (nearFeature == TFLandmark.TROLL_CAVE) {
            this.deformTerrainForTrollCloud2(primer, chunk, relativeFeatureX, relativeFeatureZ);
        }
    }

    private void flattenTerrainForFeature(WorldGenRegion primer, TFLandmark nearFeature, int x, int z, int dx, int dz) {
        BlockState b;
        int y;
        float squishFactor = 0.0f;
        int mazeHeight = 5;
        int FEATURE_BOUNDARY = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -FEATURE_BOUNDARY) {
            squishFactor = (float)(-dx - FEATURE_BOUNDARY) / 8.0f;
        } else if (dx >= FEATURE_BOUNDARY) {
            squishFactor = (float)(dx - FEATURE_BOUNDARY) / 8.0f;
        }
        if (dz <= -FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(-dz - FEATURE_BOUNDARY) / 8.0f);
        } else if (dz >= FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(dz - FEATURE_BOUNDARY) / 8.0f);
        }
        if (squishFactor > 0.0f) {
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.m_8055_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y)).m_60734_();
                if (currentTerrain == Blocks.f_50069_) continue;
                mazeHeight = (int)((float)mazeHeight + (float)(y - mazeHeight) * squishFactor);
                break;
            }
        }
        for (y = 0; y < mazeHeight; ++y) {
            b = primer.m_8055_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y));
            if (primer.m_204166_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y)).m_203565_(TFBiomes.STREAM) || !b.m_60795_() && !b.m_60767_().m_76332_()) continue;
            primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y), Blocks.f_50069_.m_49966_(), 3);
        }
        for (y = mazeHeight; y <= 127; ++y) {
            b = primer.m_8055_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y));
            if (primer.m_204166_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y)).m_203565_(TFBiomes.STREAM) || b.m_60795_() || b.m_60767_().m_76332_()) continue;
            primer.m_7731_(this.withY(primer.m_143488_().m_45615_().m_7918_(x, 0, z), y), Blocks.f_50016_.m_49966_(), 3);
        }
    }

    protected final BlockPos withY(BlockPos old, int y) {
        return new BlockPos(old.m_123341_(), y, old.m_123343_());
    }

    private void deformTerrainForTrollCloud2(WorldGenRegion primer, ChunkAccess chunkAccess, int hx, int hz) {
        for (int bx = 0; bx < 4; ++bx) {
            for (int bz = 0; bz < 4; ++bz) {
                int dx = bx * 4 - hx - 2;
                int dz = bz * 4 - hz - 2;
                int regionX = primer.m_143488_().f_45578_ + 8 >> 4;
                int regionZ = primer.m_143488_().f_45579_ + 8 >> 4;
                long seed = (long)regionX * 3129871L ^ (long)regionZ * 116129781L;
                seed = seed * seed * 42317861L + seed * 7L;
                int num0 = (int)(seed >> 12 & 3L);
                int num1 = (int)(seed >> 15 & 3L);
                int num2 = (int)(seed >> 18 & 3L);
                int num3 = (int)(seed >> 21 & 3L);
                int num4 = (int)(seed >> 9 & 3L);
                int num5 = (int)(seed >> 6 & 3L);
                int num6 = (int)(seed >> 3 & 3L);
                int num7 = (int)(seed & 3L);
                int dx2 = dx + num0 * 5 - num1 * 4;
                int dz2 = dz + num2 * 4 - num3 * 5;
                int dx3 = dx + num4 * 5 - num5 * 4;
                int dz3 = dz + num6 * 4 - num7 * 5;
                float dist0 = Mth.m_14116_((float)(dx * dx + dz * dz)) / 4.0f;
                float dist2 = Mth.m_14116_((float)(dx2 * dx2 + dz2 * dz2)) / 3.5f;
                float dist3 = Mth.m_14116_((float)(dx3 * dx3 + dz3 * dz3)) / 4.5f;
                double dist = Math.min(dist0, Math.min(dist2, dist3));
                float pr = primer.m_213780_().m_188501_();
                double cv = dist - 7.0 - (double)(pr * 3.0f);
                int y = 166;
                int depth = 4;
                if (pr < 0.1f) {
                    ++y;
                }
                if (pr > 0.6f) {
                    ++depth;
                }
                if (pr > 0.9f) {
                    ++depth;
                }
                for (int sx = 0; sx < 4; ++sx) {
                    for (int sz = 0; sz < 4; ++sz) {
                        int lx = bx * 4 + sx;
                        int lz = bz * 4 + sz;
                        BlockPos.MutableBlockPos movingPos = primer.m_143488_().m_45615_().m_122032_().m_122184_(lx, 0, lz);
                        int dY = primer.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, movingPos.m_123341_(), movingPos.m_123343_());
                        int oceanFloor = primer.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, movingPos.m_123341_(), movingPos.m_123343_());
                        if (dist < 7.0 || cv < (double)0.05f) {
                            primer.m_7731_((BlockPos)movingPos.m_142448_(y), ((Block)TFBlocks.WISPY_CLOUD.get()).m_49966_(), 3);
                            for (d = 1; d < depth; ++d) {
                                primer.m_7731_((BlockPos)movingPos.m_142448_(y - d), ((Block)TFBlocks.FLUFFY_CLOUD.get()).m_49966_(), 3);
                            }
                            primer.m_7731_((BlockPos)movingPos.m_142448_(y - depth), ((Block)TFBlocks.WISPY_CLOUD.get()).m_49966_(), 3);
                        } else if (dist < 8.0 || cv < 1.0) {
                            for (d = 1; d < depth; ++d) {
                                primer.m_7731_((BlockPos)movingPos.m_142448_(y - d), ((Block)TFBlocks.FLUFFY_CLOUD.get()).m_49966_(), 3);
                            }
                        }
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, Heightmap.Types.WORLD_SURFACE_WG, (BlockPos)movingPos, dY);
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, Heightmap.Types.WORLD_SURFACE, (BlockPos)movingPos, dY);
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, Heightmap.Types.OCEAN_FLOOR_WG, (BlockPos)movingPos, oceanFloor);
                        ChunkGeneratorTwilight.forceHeightMapLevel(chunkAccess, Heightmap.Types.OCEAN_FLOOR, (BlockPos)movingPos, oceanFloor);
                    }
                }
            }
        }
    }

    private void raiseHills(WorldGenRegion world, ChunkAccess chunk, TFLandmark nearFeature, int hdiam, int xInChunk, int zInChunk, int featureDX, int featureDZ, float hillHeight) {
        BlockPos.MutableBlockPos movingPos = world.m_143488_().m_45615_().m_7918_(xInChunk, 0, zInChunk).m_122032_();
        int groundHeight = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, movingPos.m_123341_(), movingPos.m_123343_());
        float noiseRaw = this.surfaceNoiseGetter.map(ns -> Float.valueOf(0.0f)).orElse(Float.valueOf(0.0f)).floatValue();
        float totalHeightRaw = (float)groundHeight * 0.75f + (float)this.m_6337_() * 0.25f + hillHeight + noiseRaw;
        int totalHeight = (int)((float)((int)totalHeightRaw >> 1) * 0.375f + totalHeightRaw * 0.625f);
        for (int y = groundHeight; y <= totalHeight; ++y) {
            world.m_7731_((BlockPos)movingPos.m_142448_(y), this.defaultBlock, 3);
        }
        int hollow = Math.min((int)hillHeight - 4 - nearFeature.size, totalHeight - 3);
        if (nearFeature == TFLandmark.HYDRA_LAIR) {
            int mx = featureDX + 16;
            int mz = featureDZ + 16;
            int mdist = (int)Mth.m_14116_((float)(mx * mx + mz * mz));
            int mheight = (int)(Mth.m_14089_((float)((float)mdist / ((float)hdiam / 1.5f) * (float)Math.PI)) * ((float)hdiam / 1.5f));
            hollow = Math.max(mheight - 4, hollow);
        }
        int hollowFloor = nearFeature == TFLandmark.HYDRA_LAIR ? this.m_6337_() : this.m_6337_() - 5 - (hollow >> 3);
        for (int y = hollowFloor + 1; y < hollowFloor + hollow; ++y) {
            world.m_7731_((BlockPos)movingPos.m_142448_(y), Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private void deformTerrainForYetiLair(WorldGenRegion primer, TFLandmark nearFeature, int xInChunk, int zInChunk, int featureDX, int featureDZ) {
        int y;
        float squishFactor = 0.0f;
        int topHeight = this.m_6337_() + 24;
        int outerBoundary = (nearFeature.size * 2 + 1) * 8 - 8;
        if (featureDX <= -outerBoundary) {
            squishFactor = (float)(-featureDX - outerBoundary) / 8.0f;
        } else if (featureDX >= outerBoundary) {
            squishFactor = (float)(featureDX - outerBoundary) / 8.0f;
        }
        if (featureDZ <= -outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(-featureDZ - outerBoundary) / 8.0f);
        } else if (featureDZ >= outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(featureDZ - outerBoundary) / 8.0f);
        }
        int caveBoundary = nearFeature.size * 2 * 8 - 8;
        int offset = Math.min(Math.abs(featureDX), Math.abs(featureDZ));
        int hollowCeiling = this.m_6337_() + 40 - offset * 4;
        if (featureDX >= -caveBoundary && featureDZ >= -caveBoundary && featureDX <= caveBoundary && featureDZ <= caveBoundary) {
            hollowCeiling = this.m_6337_() + 16;
        }
        hollowCeiling -= offset / 6;
        hollowCeiling = Math.min(hollowCeiling, this.m_6337_() + 16);
        int hollowFloor = this.m_6337_() - 4 + offset / 6;
        BlockPos.MutableBlockPos movingPos = primer.m_143488_().m_45615_().m_7918_(xInChunk, 0, zInChunk).m_122032_();
        if (squishFactor > 0.0f) {
            for (y = primer.m_141937_(); y <= primer.m_151558_(); ++y) {
                if (this.defaultBlock.equals(primer.m_8055_((BlockPos)movingPos.m_142448_(y)))) continue;
                topHeight = (int)((float)topHeight + (float)(y - topHeight) * squishFactor);
                hollowFloor = (int)((float)hollowFloor + (float)(y - hollowFloor) * squishFactor);
                break;
            }
        }
        for (y = primer.m_141937_(); y < topHeight; ++y) {
            Block b = primer.m_8055_((BlockPos)movingPos.m_142448_(y)).m_60734_();
            if (b != Blocks.f_50016_ && b != Blocks.f_49990_) continue;
            primer.m_7731_((BlockPos)movingPos.m_142448_(y), this.defaultBlock, 3);
        }
        for (y = hollowFloor + 1; y < hollowCeiling; ++y) {
            primer.m_7731_((BlockPos)movingPos.m_142448_(y), Blocks.f_50016_.m_49966_(), 3);
        }
        if (hollowFloor < hollowCeiling && hollowFloor < this.m_6337_() + 3) {
            primer.m_7731_((BlockPos)movingPos.m_142448_(hollowFloor), Blocks.f_50354_.m_49966_(), 3);
        }
    }

    private void addDarkForestCanopy(WorldGenRegion primer, ChunkAccess chunk, int height) {
        BlockPos blockpos = primer.m_143488_().m_45615_();
        int[] thicks = new int[25];
        boolean biomeFound = false;
        for (int dZ = 0; dZ < 5; ++dZ) {
            for (int dX = 0; dX < 5; ++dX) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        BlockPos p = blockpos.m_7918_(dX + bx << 2, 0, dZ + bz << 2);
                        Biome biome = (Biome)this.f_62137_.m_203407_(p.m_123341_() >> 2, 256, p.m_123343_() >> 2, null).m_203334_();
                        if (!TFBiomes.DARK_FOREST.m_135782_().equals((Object)primer.m_8891_().m_175515_(Registries.f_256952_).m_7981_((Object)biome)) && !TFBiomes.DARK_FOREST_CENTER.m_135782_().equals((Object)primer.m_8891_().m_175515_(Registries.f_256952_).m_7981_((Object)biome))) continue;
                        int n = dX + dZ * 5;
                        thicks[n] = thicks[n] + 1;
                        biomeFound = true;
                    }
                }
            }
        }
        if (!biomeFound) {
            return;
        }
        Vec2i nearCenter = new Vec2i();
        TFLandmark nearFeature = LegacyLandmarkPlacements.getNearestLandmark(primer.m_143488_().f_45578_, primer.m_143488_().f_45579_, (WorldGenLevel)primer, nearCenter);
        double d = 0.03125;
        for (int dZ = 0; dZ < 16; ++dZ) {
            for (int dX = 0; dX < 16; ++dX) {
                int hz;
                int rz;
                int hx;
                int rx;
                int dist;
                int qx = dX >> 2;
                int qz = dZ >> 2;
                float xweight = (float)(dX % 4) * 0.25f + 0.125f;
                float zweight = (float)(dZ % 4) * 0.25f + 0.125f;
                float thickness = (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight) + (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight) + (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight + (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight - 4.0f;
                if (nearFeature == TFLandmark.DARK_TOWER && (dist = (int)Mth.m_14116_((float)((rx = dX - (hx = nearCenter.x)) * rx + (rz = dZ - (hz = nearCenter.z)) * rz))) < 24) {
                    thickness -= (float)(24 - dist);
                }
                if (!(thickness > 1.0f)) continue;
                int dY = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, dX, dZ);
                int oceanFloor = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, dX, dZ);
                BlockPos pos = primer.m_143488_().m_45615_().m_7918_(dX, dY, dZ);
                if (chunk.m_8055_(pos).m_60767_().m_76332_()) continue;
                int noise = 0;
                int treeBottom = pos.m_123342_() + height - (int)(thickness * 0.5f);
                int treeTop = treeBottom + (int)(thickness * 1.5f);
                BlockState darkLeaves = ((Block)TFBlocks.HARDENED_DARK_LEAVES.get()).m_49966_();
                for (int y = treeBottom -= noise; y < treeTop; ++y) {
                    primer.m_7731_(pos.m_175288_(y), darkLeaves, 3);
                }
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, Heightmap.Types.WORLD_SURFACE_WG, pos, dY);
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, Heightmap.Types.WORLD_SURFACE, pos, dY);
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, Heightmap.Types.OCEAN_FLOOR_WG, pos, oceanFloor);
                ChunkGeneratorTwilight.forceHeightMapLevel(chunk, Heightmap.Types.OCEAN_FLOOR, pos, oceanFloor);
            }
        }
    }

    static void forceHeightMapLevel(ChunkAccess chunk, Heightmap.Types type, BlockPos pos, int dY) {
        chunk.m_6005_(type).m_64245_(pos.m_123341_() & 0xF, pos.m_123343_() & 0xF, dY + 1);
    }

    private static int getSpawnListIndexAt(StructureStart start, BlockPos pos) {
        int highestFoundIndex = -1;
        for (StructurePiece component : start.m_73602_()) {
            if (!component.m_73547_().m_71051_((Vec3i)pos)) continue;
            if (component instanceof TFStructureComponent) {
                TFStructureComponent tfComponent = (TFStructureComponent)component;
                if (tfComponent.spawnListIndex <= highestFoundIndex) continue;
                highestFoundIndex = tfComponent.spawnListIndex;
                continue;
            }
            return 0;
        }
        return highestFoundIndex;
    }

    @Nullable
    public static List<MobSpawnSettings.SpawnerData> gatherPotentialSpawns(StructureManager structureManager, MobCategory classification, BlockPos pos) {
        for (Structure structure : structureManager.m_220521_().m_175515_(Registries.f_256944_)) {
            TFStructureStart s;
            LegacyLandmark landmark;
            StructureStart start;
            if (!(structure instanceof LegacyLandmark) || !(start = structureManager.m_220494_(pos, (Structure)(landmark = (LegacyLandmark)structure))).m_73603_()) continue;
            if (classification != MobCategory.MONSTER) {
                return landmark.getSpawnableList(classification);
            }
            if (start instanceof TFStructureStart && (s = (TFStructureStart)start).isConquered()) {
                return null;
            }
            int index = ChunkGeneratorTwilight.getSpawnListIndexAt(start, pos);
            if (index < 0) {
                return null;
            }
            return landmark.getSpawnableMonsterList(index);
        }
        return null;
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_223133_(Holder<Biome> biome, StructureManager structureManager, MobCategory mobCategory, BlockPos pos) {
        List<MobSpawnSettings.SpawnerData> potentialStructureSpawns = ChunkGeneratorTwilight.gatherPotentialSpawns(structureManager, mobCategory, pos);
        if (potentialStructureSpawns != null) {
            return WeightedRandomList.m_146328_(potentialStructureSpawns);
        }
        return super.m_223133_(biome, structureManager, mobCategory, pos);
    }

    public TFLandmark pickLandmarkForChunk(ChunkPos chunk, WorldGenLevel world) {
        return this.pickLandmarkForChunk(chunk.f_45578_, chunk.f_45579_, world);
    }

    public TFLandmark pickLandmarkForChunk(int x, int z, WorldGenLevel world) {
        return LegacyLandmarkPlacements.pickLandmarkForChunk(x, z, world);
    }

    public boolean isLandmarkPickedForChunk(TFLandmark landmark, Holder<Biome> biome, int chunkX, int chunkZ, long seed) {
        if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkX, chunkZ)) {
            return false;
        }
        Optional biomeKey = biome.m_203543_();
        if (biomeKey.isEmpty()) {
            return false;
        }
        return this.biomeLandmarkOverrides.containsKey(biomeKey.get()) ? this.biomeGuaranteedLandmark((ResourceKey<Biome>)((ResourceKey)biomeKey.get()), landmark) : landmark == LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, seed);
    }

    public boolean biomeGuaranteedLandmark(ResourceKey<Biome> biome, TFLandmark landmark) {
        if (!this.biomeLandmarkOverrides.containsKey(biome)) {
            return false;
        }
        return this.biomeLandmarkOverrides.getOrDefault(biome, (ImmutableSet<TFLandmark>)ImmutableSet.of()).contains((Object)landmark);
    }

    public void m_255037_(RegistryAccess access, ChunkGeneratorStructureState state, StructureManager manager, ChunkAccess chunk, StructureTemplateManager templateManager) {
        ChunkPos chunkpos = chunk.m_7697_();
        SectionPos sectionpos = SectionPos.m_175562_((ChunkAccess)chunk);
        RandomState randomstate = state.m_255046_();
        state.m_255252_().forEach(p_255564_ -> {
            BiomeForcedLandmarkPlacement forced;
            StructurePlacement structureplacement = ((StructureSet)p_255564_.m_203334_()).f_210004_();
            List list = ((StructureSet)p_255564_.m_203334_()).f_210003_();
            for (StructureSet.StructureSelectionEntry structureset$structureselectionentry : list) {
                StructureStart structurestart = manager.m_220512_(sectionpos, (Structure)structureset$structureselectionentry.f_210026_().m_203334_(), (StructureAccess)chunk);
                if (structurestart == null || !structurestart.m_73603_()) continue;
                return;
            }
            if (structureplacement instanceof BiomeForcedLandmarkPlacement && (forced = (BiomeForcedLandmarkPlacement)structureplacement).isTFPlacementChunk(this, state, chunkpos.f_45578_, chunkpos.f_45579_) || structureplacement.m_255071_(state, chunkpos.f_45578_, chunkpos.f_45579_)) {
                if (list.size() == 1) {
                    this.m_223104_((StructureSet.StructureSelectionEntry)list.get(0), manager, access, randomstate, templateManager, state.m_254887_(), chunk, chunkpos, sectionpos);
                } else {
                    ArrayList arraylist = new ArrayList(list.size());
                    arraylist.addAll(list);
                    WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
                    worldgenrandom.m_190068_(state.m_254887_(), chunkpos.f_45578_, chunkpos.f_45579_);
                    int i = 0;
                    for (StructureSet.StructureSelectionEntry structureset$structureselectionentry1 : arraylist) {
                        i += structureset$structureselectionentry1.f_210027_();
                    }
                    while (!arraylist.isEmpty()) {
                        StructureSet.StructureSelectionEntry structureset$structureselectionentry2;
                        int j = worldgenrandom.m_188503_(i);
                        int k = 0;
                        Iterator iterator = arraylist.iterator();
                        while (iterator.hasNext() && (j -= (structureset$structureselectionentry2 = (StructureSet.StructureSelectionEntry)iterator.next()).f_210027_()) >= 0) {
                            ++k;
                        }
                        StructureSet.StructureSelectionEntry structureset$structureselectionentry3 = (StructureSet.StructureSelectionEntry)arraylist.get(k);
                        if (this.m_223104_(structureset$structureselectionentry3, manager, access, randomstate, templateManager, state.m_254887_(), chunk, chunkpos, sectionpos)) {
                            return;
                        }
                        arraylist.remove(k);
                        i -= structureset$structureselectionentry3.f_210027_();
                    }
                }
            }
        });
    }

    @Nullable
    public Pair<BlockPos, Holder<Structure>> m_223037_(ServerLevel level, HolderSet<Structure> targetStructures, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        ChunkGeneratorStructureState state = level.m_7726_().m_255415_();
        @Nullable Pair nearest = super.m_223037_(level, targetStructures, pos, searchRadius, skipKnownStructures);
        Object2ObjectArrayMap placementSetMap = new Object2ObjectArrayMap();
        for (Holder holder : targetStructures) {
            for (StructurePlacement structureplacement : state.m_255260_(holder)) {
                if (!(structureplacement instanceof BiomeForcedLandmarkPlacement)) continue;
                BiomeForcedLandmarkPlacement landmarkPlacement = (BiomeForcedLandmarkPlacement)structureplacement;
                placementSetMap.computeIfAbsent(landmarkPlacement, v -> new ObjectArraySet()).add(holder);
            }
        }
        if (placementSetMap.isEmpty()) {
            return nearest;
        }
        double distance = nearest == null ? Double.MAX_VALUE : ((BlockPos)nearest.getFirst()).m_123331_((Vec3i)pos);
        for (BlockPos landmarkCenterPosition : LegacyLandmarkPlacements.landmarkCenterScanner(pos, Mth.m_14167_((float)Mth.m_14116_((float)searchRadius)))) {
            for (Map.Entry landmarkPlacement : placementSetMap.entrySet()) {
                if (!((BiomeForcedLandmarkPlacement)((Object)landmarkPlacement.getKey())).isTFPlacementChunk(this, state, landmarkCenterPosition.m_123341_() >> 4, landmarkCenterPosition.m_123343_() >> 4)) continue;
                for (Holder targetStructure : targetStructures) {
                    double newDistance;
                    if (!((Set)landmarkPlacement.getValue()).contains(targetStructure) || !((newDistance = landmarkCenterPosition.m_203202_((double)pos.m_123341_(), (double)landmarkCenterPosition.m_123342_(), (double)pos.m_123343_())) < distance)) continue;
                    nearest = new Pair((Object)landmarkCenterPosition, (Object)targetStructure);
                    distance = newDistance;
                }
            }
        }
        return nearest;
    }
}

