/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import twilightforest.init.TFBiomes;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.traits.AreaTransformer0;

public enum GenLayerTFBiomes implements AreaTransformer0
{
    INSTANCE;

    private static final int RARE_BIOME_CHANCE = 15;
    private static final List<ResourceKey<Biome>> commonBiomes;
    private static final List<ResourceKey<Biome>> rareBiomes;
    private HolderGetter<Biome> registry;

    public GenLayerTFBiomes setup(HolderGetter<Biome> registry) {
        this.registry = registry;
        return this;
    }

    @Override
    public int applyPixel(Context iNoiseRandom, int x, int y) {
        if (iNoiseRandom.nextRandom(15) == 0) {
            return this.getRandomBiome(iNoiseRandom, rareBiomes);
        }
        return this.getRandomBiome(iNoiseRandom, commonBiomes);
    }

    private int getRandomBiome(Context random, List<ResourceKey<Biome>> biomes) {
        return TFBiomeProvider.getBiomeId(biomes.get(random.nextRandom(biomes.size())), this.registry);
    }

    static {
        commonBiomes = ImmutableList.of(TFBiomes.FOREST, TFBiomes.DENSE_FOREST, TFBiomes.MUSHROOM_FOREST, TFBiomes.OAK_SAVANNAH, TFBiomes.FIREFLY_FOREST);
        rareBiomes = ImmutableList.of(TFBiomes.LAKE, TFBiomes.DENSE_MUSHROOM_FOREST, TFBiomes.ENCHANTED_FOREST, TFBiomes.CLEARING, TFBiomes.SPOOKY_FOREST);
    }
}

