/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import net.minecraft.core.HolderGetter;
import net.minecraft.world.level.biome.Biome;
import twilightforest.init.TFBiomes;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.traits.CastleTransformer;

public enum GenLayerTFCompanionBiomes implements CastleTransformer
{
    INSTANCE;

    private HolderGetter<Biome> registry;

    public GenLayerTFCompanionBiomes setup(HolderGetter<Biome> registry) {
        this.registry = registry;
        return this;
    }

    @Override
    public int apply(Context noise, int up, int left, int down, int right, int center) {
        int fireSwamp = TFBiomeProvider.getBiomeId(TFBiomes.FIRE_SWAMP, this.registry);
        int swamp = TFBiomeProvider.getBiomeId(TFBiomes.SWAMP, this.registry);
        int glacier = TFBiomeProvider.getBiomeId(TFBiomes.GLACIER, this.registry);
        int snowyForest = TFBiomeProvider.getBiomeId(TFBiomes.SNOWY_FOREST, this.registry);
        int darkForestCenter = TFBiomeProvider.getBiomeId(TFBiomes.DARK_FOREST_CENTER, this.registry);
        int darkForest = TFBiomeProvider.getBiomeId(TFBiomes.DARK_FOREST, this.registry);
        int highlandsCenter = TFBiomeProvider.getBiomeId(TFBiomes.FINAL_PLATEAU, this.registry);
        int highlands = TFBiomeProvider.getBiomeId(TFBiomes.HIGHLANDS, this.registry);
        if (this.isKey(fireSwamp, center, right, left, up, down)) {
            return swamp;
        }
        if (this.isKey(glacier, center, right, left, up, down)) {
            return snowyForest;
        }
        if (this.isKey(darkForestCenter, center, right, left, up, down)) {
            return darkForest;
        }
        if (this.isKey(highlandsCenter, center, right, left, up, down)) {
            return highlands;
        }
        return center;
    }

    boolean isKey(int biome, int center, int right, int left, int up, int down) {
        return center != biome && (right == biome || left == biome || up == biome || down == biome);
    }
}

