/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFFeatureModifiers;

public class ChunkBlanketingModifier
extends PlacementModifier {
    public static final Codec<ChunkBlanketingModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("integrity").forGetter(o -> Float.valueOf(o.integrity)), (App)Heightmap.Types.f_64274_.fieldOf("heightmap").forGetter(o -> o.heightmap), (App)ResourceLocation.f_135803_.optionalFieldOf("biome_lock").forGetter(o -> o.biomeRLOptional)).apply((Applicative)instance, ChunkBlanketingModifier::new));
    public final float integrity;
    public final Heightmap.Types heightmap;
    public final Optional<ResourceLocation> biomeRLOptional;

    public ChunkBlanketingModifier(float integrity, Heightmap.Types heightmap, Optional<ResourceLocation> biomeRLOptional) {
        this.integrity = integrity;
        this.heightmap = heightmap;
        this.biomeRLOptional = biomeRLOptional;
    }

    public static ChunkBlanketingModifier addThorns() {
        return new ChunkBlanketingModifier(0.7f, Heightmap.Types.OCEAN_FLOOR_WG, Optional.of(TwilightForestMod.prefix("thornlands")));
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos placement) {
        int chunkOriginX = placement.m_123341_() & 0xFFFFFFF0;
        int chunkOriginZ = placement.m_123343_() & 0xFFFFFFF0;
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
            for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                if (random.m_188501_() > this.integrity) continue;
                BlockPos pos = new BlockPos(chunkOriginX + xInChunk, context.m_191824_(this.heightmap, chunkOriginX + xInChunk, chunkOriginZ + zInChunk), chunkOriginZ + zInChunk);
                if (this.biomeRLOptional.isPresent()) {
                    if (!this.biomeRLOptional.get().equals((Object)context.m_191831_().m_8891_().m_175515_(Registries.f_256952_).m_7981_((Object)((Biome)context.m_191831_().m_204166_(pos).get())))) continue;
                    coordinates.add(pos);
                    continue;
                }
                coordinates.add(pos);
            }
        }
        return coordinates.stream();
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)TFFeatureModifiers.CHUNK_BLANKETING.get();
    }
}

