/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFLandmark;
import twilightforest.loot.TFLootTables;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.StrongholdStones;
import twilightforest.world.components.structures.TFStructureComponent;

@Deprecated
public abstract class TFStructureComponentOld
extends TFStructureComponent {
    protected static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final StrongholdStones strongholdStones = new StrongholdStones();

    public TFStructureComponentOld(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
    }

    @Deprecated
    public TFStructureComponentOld(StructurePieceType type, TFLandmark feature, int i, int x, int y, int z) {
        super(type, i, new BoundingBox(x, y, z, x, y, z));
        this.setFeature(feature);
    }

    public TFStructureComponentOld(StructurePieceType type, TFLandmark feature, int i, BoundingBox box) {
        super(type, i, box);
        this.setFeature(feature);
    }

    public void m_73519_(@Nullable Direction facing) {
        this.f_73377_ = facing;
        this.f_73378_ = Mirror.NONE;
        if (facing == null) {
            this.f_73379_ = Rotation.NONE;
        } else {
            switch (facing) {
                case SOUTH: {
                    this.f_73379_ = Rotation.CLOCKWISE_180;
                    break;
                }
                case WEST: {
                    this.f_73379_ = Rotation.COUNTERCLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.f_73379_ = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.f_73379_ = Rotation.NONE;
                }
            }
        }
    }

    public static BoundingBox getComponentToAddBoundingBox2(int x, int y, int z, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Direction dir) {
        return switch (dir) {
            case Direction.WEST -> new BoundingBox(x - maxZ - minZ, y + minY, z + minX, x - minZ, y + maxY + minY, z + maxX + minX);
            case Direction.NORTH -> new BoundingBox(x - maxX - minX, y + minY, z - maxZ - minZ, x - minX, y + maxY + minY, z - minZ);
            case Direction.EAST -> new BoundingBox(x + minZ, y + minY, z - maxX, x + maxZ + minZ, y + maxY + minY, z - minX);
            default -> new BoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
        };
    }

    protected void setSpawner(WorldGenLevel world, Vec3i pos, BoundingBox sbb, EntityType<?> monsterID) {
        this.setSpawner(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), sbb, monsterID, v -> {});
    }

    protected void setSpawner(WorldGenLevel world, int x, int y, int z, BoundingBox sbb, EntityType<?> monsterID) {
        this.setSpawner(world, x, y, z, sbb, monsterID, v -> {});
    }

    protected void setSpawner(WorldGenLevel world, int x, int y, int z, BoundingBox sbb, EntityType<?> monsterID, Consumer<SpawnerBlockEntity> spawnerModifier) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos)) {
            BlockEntity tileEntitySpawner;
            if (world.m_8055_(pos).m_60734_() != Blocks.f_50085_) {
                world.m_7731_(pos, Blocks.f_50085_.m_49966_(), 2);
            }
            if ((tileEntitySpawner = world.m_7702_(pos)) instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)tileEntitySpawner;
                spawner.m_252803_(monsterID, world.m_213780_());
                spawnerModifier.accept(spawner);
            }
        }
    }

    protected void surroundBlockCardinal(WorldGenLevel world, BlockState block, int x, int y, int z, BoundingBox sbb) {
        this.m_73434_(world, block, x, y, z - 1, sbb);
        this.m_73434_(world, block, x, y, z + 1, sbb);
        this.m_73434_(world, block, x - 1, y, z, sbb);
        this.m_73434_(world, block, x + 1, y, z, sbb);
    }

    protected void surroundBlockCardinalRotated(WorldGenLevel world, BlockState block, int x, int y, int z, BoundingBox sbb) {
        this.m_73434_(world, (BlockState)block.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.NORTH), x, y, z - 1, sbb);
        this.m_73434_(world, (BlockState)block.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH), x, y, z + 1, sbb);
        this.m_73434_(world, (BlockState)block.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST), x - 1, y, z, sbb);
        this.m_73434_(world, (BlockState)block.m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST), x + 1, y, z, sbb);
    }

    protected void surroundBlockCorners(WorldGenLevel world, BlockState block, int x, int y, int z, BoundingBox sbb) {
        this.m_73434_(world, block, x - 1, y, z - 1, sbb);
        this.m_73434_(world, block, x - 1, y, z + 1, sbb);
        this.m_73434_(world, block, x + 1, y, z - 1, sbb);
        this.m_73434_(world, block, x + 1, y, z + 1, sbb);
    }

    protected void setSpawnerRotated(WorldGenLevel world, int x, int y, int z, Rotation rotation, EntityType<?> monsterID, BoundingBox sbb) {
        Direction oldBase = this.fakeBaseMode(rotation);
        this.setSpawner(world, x, y, z, sbb, monsterID);
        this.m_73519_(oldBase);
    }

    protected void placeTreasureAtCurrentPosition(WorldGenLevel world, int x, int y, int z, TFLootTables treasureType, BoundingBox sbb) {
        this.placeTreasureAtCurrentPosition(world, x, y, z, treasureType, false, sbb);
    }

    protected void placeTreasureAtCurrentPosition(WorldGenLevel world, int x, int y, int z, TFLootTables treasureType, boolean trapped, BoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos) && world.m_8055_(pos).m_60734_() != (trapped ? Blocks.f_50325_ : Blocks.f_50087_)) {
            treasureType.generateChest(world, pos, this.m_73549_(), trapped);
        }
    }

    protected void placeTreasureRotated(WorldGenLevel world, int x, int y, int z, Direction facing, Rotation rotation, TFLootTables treasureType, BoundingBox sbb) {
        this.placeTreasureRotated(world, x, y, z, facing, rotation, treasureType, false, sbb);
    }

    protected void placeTreasureRotated(WorldGenLevel world, int x, int y, int z, Direction facing, Rotation rotation, TFLootTables treasureType, boolean trapped, BoundingBox sbb) {
        int dz;
        int dy;
        int dx;
        BlockPos pos;
        if (facing == null) {
            TwilightForestMod.LOGGER.error("Loot Chest at {}, {}, {} has null direction, setting it to north", (Object)x, (Object)y, (Object)z);
            facing = Direction.NORTH;
        }
        if (sbb.m_71051_((Vec3i)(pos = new BlockPos(dx = this.getXWithOffsetRotated(x, z, rotation), dy = this.m_73544_(y), dz = this.getZWithOffsetRotated(x, z, rotation)))) && world.m_8055_(pos).m_60734_() != (trapped ? Blocks.f_50325_ : Blocks.f_50087_)) {
            treasureType.generateChest(world, pos, facing, trapped);
        }
    }

    protected void manualTreaurePlacement(WorldGenLevel world, int x, int y, int z, Direction facing, TFLootTables treasureType, boolean trapped, BoundingBox sbb) {
        int lootx = this.m_73392_(x, z);
        int looty = this.m_73544_(y);
        int lootz = this.m_73525_(x, z);
        BlockPos lootPos = new BlockPos(lootx, looty, lootz);
        this.m_73434_(world, (BlockState)((BlockState)(trapped ? Blocks.f_50325_ : Blocks.f_50087_).m_49966_().m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT)).m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing), x, y, z, sbb);
        treasureType.generateChestContents(world, lootPos);
    }

    protected void setDoubleLootChest(WorldGenLevel world, int x, int y, int z, int otherx, int othery, int otherz, @Nullable Direction facing, TFLootTables treasureType, BoundingBox sbb, boolean trapped) {
        this.setDoubleLootChest(world, x, y, z, otherx, othery, otherz, facing, treasureType, treasureType, sbb, trapped);
    }

    protected void setDoubleLootChest(WorldGenLevel world, int x, int y, int z, int otherx, int othery, int otherz, @Nullable Direction facing, TFLootTables treasureType, TFLootTables secondaryLootType, BoundingBox sbb, boolean trapped) {
        if (facing == null) {
            TwilightForestMod.LOGGER.error("Loot Chest at {}, {}, {} has null direction, setting it to north", (Object)x, (Object)y, (Object)z);
            facing = Direction.NORTH;
        }
        boolean flipContents = world.m_213780_().m_188499_();
        BlockPos firstChestPos = new BlockPos(this.m_73392_(x, z), this.m_73544_(y), this.m_73525_(x, z));
        BlockPos secondChestPos = new BlockPos(this.m_73392_(otherx, otherz), this.m_73544_(othery), this.m_73525_(otherx, otherz));
        this.m_73434_(world, (BlockState)((BlockState)(trapped ? Blocks.f_50325_ : Blocks.f_50087_).m_49966_().m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT)).m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing), x, y, z, sbb);
        this.m_73434_(world, (BlockState)((BlockState)(trapped ? Blocks.f_50325_ : Blocks.f_50087_).m_49966_().m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.RIGHT)).m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing), otherx, othery, otherz, sbb);
        treasureType.generateChestContents(world, flipContents ? secondChestPos : firstChestPos);
        secondaryLootType.generateChestContents(world, flipContents ? firstChestPos : secondChestPos);
    }

    protected void placeTripwire(WorldGenLevel world, int x, int y, int z, int size, Direction facing, BoundingBox sbb) {
        int dx = facing.m_122429_();
        int dz = facing.m_122431_();
        BlockState tripwireHook = Blocks.f_50266_.m_49966_();
        this.m_73434_(world, (BlockState)tripwireHook.m_61124_((Property)TripWireHookBlock.f_57667_, (Comparable)facing.m_122424_()), x, y, z, sbb);
        this.m_73434_(world, (BlockState)tripwireHook.m_61124_((Property)TripWireHookBlock.f_57667_, (Comparable)facing), x + dx * size, y, z + dz * size, sbb);
        BlockState tripwire = Blocks.f_50267_.m_49966_();
        for (int i = 1; i < size; ++i) {
            this.m_73434_(world, tripwire, x + dx * i, y, z + dz * i, sbb);
        }
    }

    protected void placeSignAtCurrentPosition(WorldGenLevel world, int x, int y, int z, String string0, String string1, BoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos) && world.m_8055_(pos).m_60734_() != Blocks.f_50095_) {
            world.m_7731_(pos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(this.m_73549_().m_122416_() * 4)), 2);
            SignBlockEntity teSign = (SignBlockEntity)world.m_7702_(pos);
            if (teSign != null) {
                teSign.m_59732_(1, (Component)Component.m_237113_((String)string0));
                teSign.m_59732_(2, (Component)Component.m_237113_((String)string1));
            }
        }
    }

    protected int[] offsetTowerCoords(int x, int y, int z, int towerSize, Direction direction) {
        int dx = this.m_73392_(x, z);
        int dy = this.m_73544_(y);
        int dz = this.m_73525_(x, z);
        if (direction == Direction.SOUTH) {
            return new int[]{dx + 1, dy - 1, dz - towerSize / 2};
        }
        if (direction == Direction.WEST) {
            return new int[]{dx + towerSize / 2, dy - 1, dz + 1};
        }
        if (direction == Direction.NORTH) {
            return new int[]{dx - 1, dy - 1, dz + towerSize / 2};
        }
        if (direction == Direction.EAST) {
            return new int[]{dx - towerSize / 2, dy - 1, dz - 1};
        }
        return new int[]{x, y, z};
    }

    protected BlockPos offsetTowerCCoords(int x, int y, int z, int towerSize, Direction direction) {
        int dx = this.m_73392_(x, z);
        int dy = this.m_73544_(y);
        int dz = this.m_73525_(x, z);
        switch (direction) {
            case SOUTH: {
                return new BlockPos(dx + 1, dy - 1, dz - towerSize / 2);
            }
            case WEST: {
                return new BlockPos(dx + towerSize / 2, dy - 1, dz + 1);
            }
            case NORTH: {
                return new BlockPos(dx - 1, dy - 1, dz + towerSize / 2);
            }
            case EAST: {
                return new BlockPos(dx - towerSize / 2, dy - 1, dz - 1);
            }
        }
        return new BlockPos(x, y, z);
    }

    protected int m_73392_(int x, int z) {
        Direction enumfacing = this.m_73549_();
        if (enumfacing == null) {
            return x;
        }
        return switch (enumfacing) {
            case Direction.SOUTH -> this.f_73383_.m_162395_() + x;
            case Direction.WEST -> this.f_73383_.m_162399_() - z;
            case Direction.NORTH -> this.f_73383_.m_162399_() - x;
            case Direction.EAST -> this.f_73383_.m_162395_() + z;
            default -> x;
        };
    }

    protected int m_73525_(int x, int z) {
        Direction enumfacing = this.m_73549_();
        if (enumfacing == null) {
            return z;
        }
        return switch (enumfacing) {
            case Direction.SOUTH -> this.f_73383_.m_162398_() + z;
            case Direction.WEST -> this.f_73383_.m_162398_() + x;
            case Direction.NORTH -> this.f_73383_.m_162401_() - z;
            case Direction.EAST -> this.f_73383_.m_162401_() - x;
            default -> z;
        };
    }

    private Direction fakeBaseMode(Rotation rotationsCW) {
        Direction oldBaseMode = this.m_73549_();
        if (oldBaseMode != null) {
            Direction pretendBaseMode = oldBaseMode;
            pretendBaseMode = rotationsCW.m_55954_(pretendBaseMode);
            this.m_73519_(pretendBaseMode);
        }
        return oldBaseMode;
    }

    protected int getXWithOffsetRotated(int x, int z, Rotation rotationsCW) {
        Direction oldMode = this.fakeBaseMode(rotationsCW);
        int ret = this.m_73392_(x, z);
        this.m_73519_(oldMode);
        return ret;
    }

    protected int getZWithOffsetRotated(int x, int z, Rotation rotationsCW) {
        Direction oldMode = this.fakeBaseMode(rotationsCW);
        int ret = this.m_73525_(x, z);
        this.m_73519_(oldMode);
        return ret;
    }

    protected void setBlockStateRotated(WorldGenLevel world, BlockState state, int x, int y, int z, Rotation rotationsCW, BoundingBox sbb) {
        Direction oldMode = this.fakeBaseMode(rotationsCW);
        this.m_73434_(world, state, x, y, z, sbb);
        this.m_73519_(oldMode);
    }

    protected BlockState m_73398_(BlockGetter world, int x, int y, int z, BoundingBox sbb) {
        return super.m_73398_(world, x, y, z, sbb);
    }

    @Override
    protected void m_73434_(WorldGenLevel worldIn, BlockState blockstateIn, int x, int y, int z, BoundingBox sbb) {
        super.m_73434_(worldIn, blockstateIn, x, y, z, sbb);
    }

    public BlockState getBlockStateFromPosRotated(WorldGenLevel world, int x, int y, int z, BoundingBox sbb, Rotation rotationsCW) {
        Direction oldMode = this.fakeBaseMode(rotationsCW);
        BlockState ret = this.m_73398_((BlockGetter)world, x, y, z, sbb);
        this.m_73519_(oldMode);
        return ret;
    }

    protected void fillBlocksRotated(WorldGenLevel world, BoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState state, Rotation rotation) {
        Direction oldBase = this.fakeBaseMode(rotation);
        this.m_73441_(world, sbb, minX, minY, minZ, maxX, maxY, maxZ, state, state, false);
        this.m_73519_(oldBase);
    }

    protected void randomlyFillBlocksRotated(WorldGenLevel worldIn, BoundingBox boundingboxIn, RandomSource rand, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockstate1, BlockState blockstate2, Rotation rotation) {
        Direction oldBase = this.fakeBaseMode(rotation);
        boolean minimumLightLevel = true;
        this.m_226788_(worldIn, boundingboxIn, rand, chance, minX, minY, minZ, maxX, maxY, maxZ, blockstate1, blockstate2, false, true);
        this.m_73519_(oldBase);
    }

    public void replaceAirAndLiquidDownwardsRotated(WorldGenLevel world, BlockState state, int x, int y, int z, Rotation rotation, BoundingBox sbb) {
        Direction oldBaseMode = this.fakeBaseMode(rotation);
        this.m_73528_(world, state, x, y, z, sbb);
        this.m_73519_(oldBaseMode);
    }

    protected void fillAirRotated(WorldGenLevel world, BoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Rotation rotation) {
        Direction oldBaseMode = this.fakeBaseMode(rotation);
        this.m_73535_(world, sbb, minX, minY, minZ, maxX, maxY, maxZ);
        this.m_73519_(oldBaseMode);
    }

    protected void fillWithAir(WorldGenLevel world, BoundingBox boundingBox, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Predicate<BlockState> predicate) {
        this.fillWithBlocks(world, boundingBox, xMin, yMin, zMin, xMax, yMax, zMax, Blocks.f_50016_.m_49966_(), predicate);
    }

    protected void fillWithBlocks(WorldGenLevel world, BoundingBox boundingBox, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockState state, Predicate<BlockState> predicate) {
        this.fillWithBlocks(world, boundingBox, xMin, yMin, zMin, xMax, yMax, zMax, state, state, predicate);
    }

    protected void fillWithBlocks(WorldGenLevel world, BoundingBox boundingBox, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockState borderState, BlockState interiorState, Predicate<BlockState> predicate) {
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!predicate.test(this.m_73398_((BlockGetter)world, x, y, z, boundingBox))) continue;
                    boolean isBorder = yMin != yMax && (y == yMin || y == yMax) || xMin != xMax && (x == xMin || x == xMax) || zMin != zMax && (z == zMin || z == zMax);
                    this.m_73434_(world, isBorder ? borderState : interiorState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected static StructurePiece.BlockSelector getStrongholdStones() {
        return strongholdStones;
    }

    protected Direction getStructureRelativeRotation(Rotation rotationsCW) {
        return rotationsCW.m_55954_(this.m_73549_());
    }

    protected int getAverageGroundLevel(WorldGenLevel world, ChunkGenerator generator, BoundingBox boundingBox) {
        int yTotal = 0;
        int count = 0;
        int yStart = Mth.m_14045_((int)generator.m_6337_(), (int)this.f_73383_.m_162396_(), (int)this.f_73383_.m_162400_());
        for (int z = this.f_73383_.m_162398_(); z <= this.f_73383_.m_162401_(); ++z) {
            for (int x = this.f_73383_.m_162395_(); x <= this.f_73383_.m_162399_(); ++x) {
                BlockPos pos = new BlockPos(x, yStart, z);
                if (!boundingBox.m_71051_((Vec3i)pos)) continue;
                BlockPos topPos = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos);
                yTotal += Math.max(topPos.m_123342_(), generator.m_142051_((LevelHeightAccessor)world));
                ++count;
            }
        }
        if (count == 0) {
            return Integer.MIN_VALUE;
        }
        return yTotal / count;
    }

    protected int findGroundLevel(WorldGenLevel world, BoundingBox sbb, int start, Predicate<BlockState> predicate) {
        Vec3i center = BoundingBoxUtils.getCenter(sbb);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(center.m_123341_(), 0, center.m_123343_());
        for (int y = start; y > 0; --y) {
            pos.m_142448_(y);
            if (!predicate.test(world.m_8055_((BlockPos)pos))) continue;
            return y;
        }
        return 0;
    }

    protected boolean isBoundingBoxOutsideBiomes(WorldGenLevel world, Predicate<Biome> predicate) {
        int minX = this.f_73383_.m_162395_() - 1;
        int minZ = this.f_73383_.m_162398_() - 1;
        int maxX = this.f_73383_.m_162399_() + 1;
        int maxZ = this.f_73383_.m_162401_() + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (predicate.test((Biome)world.m_204166_((BlockPos)pos.m_122178_(x, 0, z)).m_203334_())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static StructurePiece findIntersectingExcluding(List<StructurePiece> list, BoundingBox toCheck, StructurePiece exclude) {
        StructurePiece structurecomponent;
        Iterator<StructurePiece> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((structurecomponent = iterator.next()) == exclude || structurecomponent.m_73547_() == null || !structurecomponent.m_73547_().m_71049_(toCheck));
        return structurecomponent;
    }

    public BlockPos getBlockPosWithOffset(int x, int y, int z) {
        return new BlockPos(this.m_73392_(x, z), this.m_73544_(y), this.m_73525_(x, z));
    }

    protected static BlockState getStairState(BlockState stairState, Direction direction, boolean isTopHalf) {
        return (BlockState)((BlockState)stairState.m_61124_((Property)StairBlock.f_56841_, (Comparable)direction)).m_61124_((Property)StairBlock.f_56842_, (Comparable)(isTopHalf ? Half.TOP : Half.BOTTOM));
    }

    protected static BlockState getSlabState(BlockState inputBlockState, SlabType half) {
        return (BlockState)inputBlockState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)half);
    }
}

