/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.stronghold;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFConfiguredFeatures;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.stronghold.StructureTFStrongholdComponent;

public class StrongholdAtriumComponent
extends StructureTFStrongholdComponent {
    private boolean enterBottom;

    public StrongholdAtriumComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFSAt.get(), nbt);
        this.enterBottom = nbt.m_128471_("enterBottom");
    }

    public StrongholdAtriumComponent(TFLandmark feature, int i, Direction facing, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFSAt.get(), feature, i, facing, x, y, z);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128379_("enterBottom", this.enterBottom);
    }

    @Override
    public BoundingBox generateBoundingBox(Direction facing, int x, int y, int z) {
        if (y > -15) {
            this.enterBottom = false;
        } else if (y < -21) {
            this.enterBottom = true;
        } else {
            boolean bl = this.enterBottom = (z & 1) == 0;
        }
        if (this.enterBottom) {
            return StructureTFStrongholdComponent.getComponentToAddBoundingBox(x, y, z, -4, -1, 0, 18, 14, 18, facing);
        }
        return StructureTFStrongholdComponent.getComponentToAddBoundingBox(x, y, z, -13, -8, 0, 18, 14, 18, facing);
    }

    @Override
    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource random) {
        super.m_214092_(parent, list, random);
        if (this.enterBottom) {
            this.addDoor(4, 1, 0);
            this.addNewComponent(parent, list, random, Rotation.CLOCKWISE_180, 13, 8, -1);
        } else {
            this.addDoor(13, 8, 0);
            this.addNewComponent(parent, list, random, Rotation.CLOCKWISE_180, 4, 1, -1);
        }
        this.addNewComponent(parent, list, random, Rotation.NONE, 13, 1, 18);
        this.addNewComponent(parent, list, random, Rotation.NONE, 4, 8, 18);
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.placeStrongholdWalls(world, sbb, 0, 0, 0, 17, 13, 17, rand, this.deco.randomBlocks);
        this.m_226776_(world, sbb, 1, 6, 1, 16, 7, 16, false, rand, this.deco.randomBlocks);
        this.m_73441_(world, sbb, 5, 8, 5, 12, 8, 12, this.deco.fenceState, AIR, false);
        this.m_73535_(world, sbb, 6, 6, 6, 11, 8, 11);
        this.placeBalconyPillar(world, sbb, Rotation.NONE);
        this.placeBalconyPillar(world, sbb, Rotation.CLOCKWISE_90);
        this.placeBalconyPillar(world, sbb, Rotation.CLOCKWISE_180);
        this.placeBalconyPillar(world, sbb, Rotation.COUNTERCLOCKWISE_90);
        this.m_226776_(world, sbb, 1, 1, 1, 1, 12, 2, false, rand, this.deco.randomBlocks);
        this.m_226776_(world, sbb, 2, 1, 1, 2, 12, 1, false, rand, this.deco.randomBlocks);
        this.m_226776_(world, sbb, 16, 1, 1, 16, 12, 2, false, rand, this.deco.randomBlocks);
        this.m_226776_(world, sbb, 15, 1, 1, 15, 12, 1, false, rand, this.deco.randomBlocks);
        this.m_226776_(world, sbb, 1, 1, 15, 1, 12, 16, false, rand, this.deco.randomBlocks);
        this.m_226776_(world, sbb, 2, 1, 16, 2, 12, 16, false, rand, this.deco.randomBlocks);
        this.m_226776_(world, sbb, 16, 1, 15, 16, 12, 16, false, rand, this.deco.randomBlocks);
        this.m_226776_(world, sbb, 15, 1, 16, 15, 12, 16, false, rand, this.deco.randomBlocks);
        BlockState grass = Blocks.f_50440_.m_49966_();
        this.m_226788_(world, sbb, rand, 0.5f, 6, 0, 6, 11, 0, 11, grass, grass, false, false);
        this.m_73441_(world, sbb, 7, 0, 7, 10, 0, 10, grass, AIR, false);
        this.spawnATree(world, generator, rand.m_188503_(5), 8, 1, 8, sbb);
        this.placeCornerStatue(world, 2, 8, 2, 0, sbb);
        this.placeCornerStatue(world, 2, 1, 15, 1, sbb);
        this.placeCornerStatue(world, 15, 1, 2, 2, sbb);
        this.placeCornerStatue(world, 15, 8, 15, 3, sbb);
        this.placeDoors(world, sbb);
    }

    private void spawnATree(WorldGenLevel world, ChunkGenerator generator, int treeNum, int x, int y, int z, BoundingBox sbb) {
        BlockPos pos = this.getBlockPosWithOffset(x, y, z);
        if (sbb.m_71051_((Vec3i)pos)) {
            ResourceKey treeGen = switch (treeNum) {
                case 1 -> TreeFeatures.f_195129_;
                case 2 -> TreeFeatures.f_195125_;
                case 3 -> TFConfiguredFeatures.TWILIGHT_OAK_TREE;
                case 4 -> TFConfiguredFeatures.RAINBOW_OAK_TREE;
                default -> TreeFeatures.f_195123_;
            };
            for (int i = 0; i < 100 && !((ConfiguredFeature)world.m_8891_().m_175515_(Registries.f_256911_).m_6246_(treeGen)).m_224953_(world, generator, world.m_213780_(), pos); ++i) {
            }
        }
    }

    private void placeBalconyPillar(WorldGenLevel world, BoundingBox sbb, Rotation rotation) {
        this.fillBlocksRotated(world, sbb, 5, 1, 5, 5, 12, 5, this.deco.pillarState, rotation);
        this.setBlockStateRotated(world, StrongholdAtriumComponent.getStairState(this.deco.stairState, Rotation.COUNTERCLOCKWISE_90.m_55954_(Direction.WEST), false), 5, 1, 6, rotation, sbb);
        this.setBlockStateRotated(world, StrongholdAtriumComponent.getStairState(this.deco.stairState, Rotation.CLOCKWISE_180.m_55954_(Direction.WEST), false), 6, 1, 5, rotation, sbb);
        this.setBlockStateRotated(world, StrongholdAtriumComponent.getStairState(this.deco.stairState, Rotation.COUNTERCLOCKWISE_90.m_55954_(Direction.WEST), true), 5, 5, 6, rotation, sbb);
        this.setBlockStateRotated(world, StrongholdAtriumComponent.getStairState(this.deco.stairState, Rotation.CLOCKWISE_180.m_55954_(Direction.WEST), true), 6, 5, 5, rotation, sbb);
        this.setBlockStateRotated(world, StrongholdAtriumComponent.getStairState(this.deco.stairState, Rotation.COUNTERCLOCKWISE_90.m_55954_(Direction.WEST), true), 5, 12, 6, rotation, sbb);
        this.setBlockStateRotated(world, StrongholdAtriumComponent.getStairState(this.deco.stairState, Rotation.CLOCKWISE_180.m_55954_(Direction.WEST), true), 6, 12, 5, rotation, sbb);
    }
}

