/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.trollcave;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFConfiguredFeatures;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.util.RotationUtil;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.trollcave.CloudCastleComponent;
import twilightforest.world.components.structures.trollcave.TrollCaveConnectComponent;
import twilightforest.world.components.structures.trollcave.TrollVaultComponent;

public class TrollCaveMainComponent
extends TFStructureComponentOld {
    protected int size;
    protected int height;

    public TrollCaveMainComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        this((StructurePieceType)TFStructurePieceTypes.TFTCMai.get(), nbt);
    }

    public TrollCaveMainComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.size = nbt.m_128451_("size");
        this.height = nbt.m_128451_("height");
    }

    public TrollCaveMainComponent(StructurePieceType type, TFLandmark feature, int i, int x, int y, int z) {
        super(type, feature, i, x, y, z);
        this.m_73519_(Direction.SOUTH);
        this.size = 30;
        this.height = 20;
        int radius = this.size / 2;
        this.f_73383_ = feature.getComponentToAddBoundingBox(x, y, z, -radius, -this.height, -radius, this.size, this.height, this.size, Direction.SOUTH);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128405_("size", this.size);
        tagCompound.m_128405_("height", this.height);
    }

    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        for (Rotation caveRotation : RotationUtil.ROTATIONS) {
            BlockPos dest = this.getValidOpening(rand, caveRotation);
            this.makeSmallerCave(list, rand, this.m_73548_() + 1, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), 18, 15, caveRotation);
        }
        CloudCastleComponent castle = new CloudCastleComponent(this.getFeatureType(), this.m_73548_() + 1, this.f_73383_.m_162395_() + (this.f_73383_.m_162399_() - this.f_73383_.m_162395_()) / 2, 168, this.f_73383_.m_162398_() + (this.f_73383_.m_162401_() - this.f_73383_.m_162398_()) / 2);
        list.m_142679_((StructurePiece)castle);
        castle.m_214092_(this, list, rand);
        TrollVaultComponent vault = new TrollVaultComponent(this.getFeatureType(), this.m_73548_() + 1, this.f_73383_.m_162395_() + (this.f_73383_.m_162399_() - this.f_73383_.m_162395_()) / 2, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + (this.f_73383_.m_162401_() - this.f_73383_.m_162398_()) / 2);
        list.m_142679_((StructurePiece)vault);
        vault.m_214092_(this, list, rand);
    }

    protected boolean makeSmallerCave(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int caveSize, int caveHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        BlockPos dest = this.offsetTowerCCoords(x, y, z, caveSize, direction);
        TrollCaveConnectComponent cave = new TrollCaveConnectComponent(this.getFeatureType(), index, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), caveSize, caveHeight, direction);
        StructurePiece intersect = list.m_141921_(cave.m_73547_());
        if (intersect == null || intersect == this) {
            list.m_142679_((StructurePiece)cave);
            cave.m_214092_(this, list, rand);
            return true;
        }
        return false;
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos.MutableBlockPos dest;
        int i;
        RandomSource decoRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L));
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        for (i = 0; i < 128; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, BlockSpikeFeature.STONE_STALACTITE, (Vec3i)dest.m_175288_(this.height), sbb, true);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, BlockSpikeFeature.STONE_STALACTITE, (Vec3i)dest.m_175288_(0), sbb, false);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateAtSurface(world, generator, TFConfiguredFeatures.UBEROUS_SOIL_PATCH_BIG, decoRNG, dest.m_123341_(), dest.m_123343_(), sbb);
        }
    }

    protected BlockPos.MutableBlockPos getCoordsInCave(RandomSource rand) {
        return new BlockPos.MutableBlockPos(rand.m_188503_(this.size - 1), rand.m_188503_(this.height - 1), rand.m_188503_(this.size - 1));
    }

    protected void hollowCaveMiddle(WorldGenLevel world, BoundingBox boundingBox, RandomSource rand, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int threshold = this.size / 5;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int ez;
                    int ey;
                    int ex = Math.min(x - minX, maxX - x);
                    double dist = Math.sqrt(ex * (ey = Math.min((y - minY) * 2, maxY - y)) * (ez = Math.min(z - minZ, maxZ - z)));
                    if (dist > (double)threshold) {
                        this.m_73434_(world, Blocks.f_50016_.m_49966_(), x, y, z, boundingBox);
                        continue;
                    }
                    if (dist != (double)threshold || rand.m_188503_(4) != 0 || !this.m_73398_((BlockGetter)world, x, y, z, boundingBox).m_204336_(BlockTags.f_13061_)) continue;
                    this.m_73434_(world, ((Block)TFBlocks.TROLLSTEINN.get()).m_49966_(), x, y, z, boundingBox);
                }
            }
        }
    }

    @Nullable
    public BlockPos getValidOpening(RandomSource rand, Rotation direction) {
        int offset = this.size / 4;
        int wLength = this.size - offset * 2;
        if (direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180) {
            int rx = direction == Rotation.NONE ? this.size - 1 : 0;
            int rz = offset + rand.m_188503_(wLength);
            int ry = 0;
            return new BlockPos(rx, ry, rz);
        }
        if (direction == Rotation.CLOCKWISE_90 || direction == Rotation.COUNTERCLOCKWISE_90) {
            int rx = offset + rand.m_188503_(wLength);
            int rz = direction == Rotation.CLOCKWISE_90 ? this.size - 1 : 0;
            int ry = rand.m_188503_(offset) - rand.m_188503_(offset);
            return new BlockPos(rx, ry, rz);
        }
        return null;
    }

    @Override
    protected BlockPos offsetTowerCCoords(int x, int y, int z, int towerSize, Direction direction) {
        int dx = this.m_73392_(x, z);
        int dy = this.m_73544_(y);
        int dz = this.m_73525_(x, z);
        if (direction == Direction.SOUTH) {
            return new BlockPos(dx - 1, dy - 1, dz - towerSize / 2);
        }
        if (direction == Direction.WEST) {
            return new BlockPos(dx + towerSize / 2, dy - 1, dz - 1);
        }
        if (direction == Direction.NORTH) {
            return new BlockPos(dx + 1, dy - 1, dz + towerSize / 2);
        }
        if (direction == Direction.EAST) {
            return new BlockPos(dx - towerSize / 2, dy - 1, dz + 1);
        }
        return new BlockPos(x, y, z);
    }

    protected void generateBlockSpike(WorldGenLevel world, Stalactite config, Vec3i pos, BoundingBox sbb, boolean hanging) {
        this.generateBlockSpike(world, config, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), sbb, hanging);
    }

    protected void generateBlockSpike(WorldGenLevel world, Stalactite config, int x, int y, int z, BoundingBox sbb, boolean hanging) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos)) {
            RandomSource stalRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)dx * (long)dz));
            BlockSpikeFeature.startSpike(world, pos, config, stalRNG, hanging);
        }
    }

    protected void generateAtSurface(WorldGenLevel world, ChunkGenerator generator, ResourceKey<ConfiguredFeature<?, ?>> feature, RandomSource rand, int x, int z, BoundingBox sbb) {
        int dx = this.m_73392_(x, z);
        int dz = this.m_73525_(x, z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(dx, WorldUtil.getSeaLevel(Objects.requireNonNull(WorldUtil.getChunkGenerator((LevelAccessor)world))) + 15, dz);
        for (int i = 0; i < 15; ++i) {
            pos.m_122184_(0, 1, 0);
            if (!sbb.m_71051_((Vec3i)pos) || !world.m_8055_(pos.m_7494_()).m_60795_()) continue;
            ((ConfiguredFeature)world.m_8891_().m_175515_(Registries.f_256911_).m_6246_(feature)).m_224953_(world, generator, rand, (BlockPos)pos);
            break;
        }
    }

    protected void makeTreasureCrate(WorldGenLevel world, BoundingBox sbb) {
        int mid = this.size / 2;
        this.m_73441_(world, sbb, mid - 2, 0, mid - 2, mid + 1, 3, mid + 1, Blocks.f_50080_.m_49966_(), Blocks.f_50080_.m_49966_(), false);
        this.m_73535_(world, sbb, mid - 1, 1, mid - 1, mid, 2, mid);
        this.placeTreasureAtCurrentPosition(world, mid, 1, mid, TFLootTables.TROLL_GARDEN, false, sbb);
    }
}

