/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.blockentity;

import com.tristankechlo.toolleveling.init.ModRegistry;
import com.tristankechlo.toolleveling.menu.ToolLevelingTableMenu;
import com.tristankechlo.toolleveling.utils.Utils;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ToolLevelingTableBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private final Component CUSTOMNAME = Component.m_237115_((String)"container.toolleveling.tool_leveling_table");
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
    public static final int NUMBER_OF_SLOTS = 16;
    public static final int[] SLOTS = IntStream.range(1, 16).toArray();
    public long bonusPoints = 0L;

    public ToolLevelingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.TLT_TILE_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.bonusPoints = tag.m_128454_("BonusPoints");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128356_("BonusPoints", this.bonusPoints);
    }

    public ItemStack getStackToEnchant() {
        if (((ItemStack)this.items.get(0)).m_150930_(Items.f_41852_)) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(0);
    }

    public long getInventoryWorth() {
        long worth = 0L;
        for (int i = 1; i < 16; ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_()) continue;
            worth += Utils.getStackWorth(stack);
        }
        return worth;
    }

    public boolean decreaseInventoryWorth(long upgradeCost) {
        long invWorth = this.getInventoryWorth() + this.bonusPoints;
        if (upgradeCost > invWorth) {
            return false;
        }
        if (upgradeCost <= this.bonusPoints) {
            this.bonusPoints -= upgradeCost;
            this.m_6596_();
            return true;
        }
        upgradeCost -= this.bonusPoints;
        this.bonusPoints = 0L;
        for (int i = 1; i < 16; ++i) {
            ItemStack stack = ((ItemStack)this.items.get(i)).m_41777_();
            if (stack.m_41619_() || upgradeCost <= 0L) continue;
            long stackWorth = Utils.getStackWorth(stack);
            if (stackWorth <= upgradeCost) {
                upgradeCost -= stackWorth;
                stack = ItemStack.f_41583_;
            } else {
                long itemWorth = Utils.getItemWorth(stack);
                int stackCount = stack.m_41613_();
                for (int j = 0; j < stack.m_41613_() && upgradeCost > 0L && stackCount != 0; ++j) {
                    if (itemWorth > upgradeCost) {
                        --stackCount;
                        this.bonusPoints = Math.abs(upgradeCost - itemWorth);
                        upgradeCost = 0L;
                        continue;
                    }
                    --stackCount;
                    upgradeCost -= itemWorth;
                }
                stack.m_41764_(stackCount);
            }
            this.items.set(i, (Object)stack);
        }
        this.m_6596_();
        return true;
    }

    public Component m_7755_() {
        return this.CUSTOMNAME;
    }

    public int m_6643_() {
        return 16;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int p_18942_, int p_18943_) {
        this.m_6596_();
        return ContainerHelper.m_18969_(this.items, (int)p_18942_, (int)p_18943_);
    }

    public ItemStack m_8016_(int p_18951_) {
        return ContainerHelper.m_18966_(this.items, (int)p_18951_);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_6211_() {
        this.items.clear();
    }

    protected Component m_6820_() {
        return this.CUSTOMNAME;
    }

    public void m_6596_() {
        super.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    protected AbstractContainerMenu m_6555_(int windowID, Inventory playerinv) {
        return new ToolLevelingTableMenu(windowID, playerinv, (Container)this, this.f_58858_);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128356_("BonusPoints", this.bonusPoints);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.bonusPoints = tag.m_128454_("BonusPoints");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128356_("BonusPoints", this.bonusPoints);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.bonusPoints = tag.m_128454_("BonusPoints");
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack stack, Direction side) {
        return index == 0 ? false : this.m_7013_(index, stack);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index > 0 && !stack.m_41793_() && !stack.m_41763_();
    }

    public boolean m_7157_(int index, ItemStack stack, Direction side) {
        return this.m_7155_(index, stack, side);
    }
}

