/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.client.screen.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tristankechlo.toolleveling.client.screen.ItemValueScreen;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemValueEntry
extends ObjectSelectionList.Entry<ItemValueEntry> {
    private final ItemValueScreen screen;
    private final NonNullList<Tuple<ItemStack, Long>> list;
    private static Component NARRATION = null;

    public ItemValueEntry(ItemValueScreen screen, NonNullList<Tuple<ItemStack, Long>> list) {
        this.screen = screen;
        if (list.size() != 7) {
            throw new IllegalArgumentException("the size of the list needs to be 7");
        }
        this.list = list;
    }

    public void m_6311_(PoseStack mStack, int index, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        int indexWidth = entryWidth / 7;
        for (int i = 0; i < this.list.size(); ++i) {
            int x = left + i * indexWidth;
            int y = top + 3;
            Tuple tuple = (Tuple)this.list.get(i);
            this.screen.getMinecraft().m_91291_().m_115123_((ItemStack)tuple.m_14418_(), x, y);
            if (!this.isMouseOverItem(x, y, mouseX, mouseY)) continue;
            this.renderItemTooltip(mStack, (ItemStack)tuple.m_14418_(), mouseX, mouseY, (Long)tuple.m_14419_());
        }
    }

    private void renderItemTooltip(PoseStack mStack, ItemStack iStack, int mouseX, int mouseY, long worth) {
        List tooltips = this.screen.m_96555_(iStack);
        tooltips.add(Component.m_237110_((String)"screen.toolleveling.item_value_worth", (Object[])new Object[]{worth}).m_130940_(ChatFormatting.DARK_GRAY));
        this.screen.m_96597_(mStack, tooltips, mouseX, mouseY);
    }

    private boolean isMouseOverItem(int left, int top, int mouseX, int mouseY) {
        return mouseX > left && mouseX <= left + 16 && mouseY > top && mouseY <= top + 16;
    }

    public Component m_142172_() {
        if (NARRATION == null) {
            NARRATION = Component.m_237115_((String)"screen.toolleveling.item_values");
        }
        return NARRATION;
    }
}

