/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tristankechlo.toolleveling.commands.ResponseHelper;
import com.tristankechlo.toolleveling.config.util.ConfigIdentifier;
import com.tristankechlo.toolleveling.config.util.ConfigManager;
import com.tristankechlo.toolleveling.network.PacketHandler;
import com.tristankechlo.toolleveling.network.packets.OpenItemValueScreenPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.command.EnumArgument;

public final class ToolLevelingCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"toolleveling").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"config").requires(source -> source.m_6761_(3))).then(Commands.m_82127_((String)"reload").executes(ToolLevelingCommand::configReload))).then(Commands.m_82127_((String)"show").then(Commands.m_82129_((String)"identifier", (ArgumentType)EnumArgument.enumArgument(ConfigIdentifier.class)).executes(ToolLevelingCommand::configShow)))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"identifier", (ArgumentType)EnumArgument.enumArgument(ConfigIdentifier.class)).executes(ToolLevelingCommand::configReset)))).then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"identifier", (ArgumentType)EnumArgument.enumArgument(ConfigIdentifier.class)).executes(ToolLevelingCommand::configInfo))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"openitemvalues").requires(source -> source.m_6761_(0))).executes(ToolLevelingCommand::showScreen))).then(Commands.m_82127_((String)"github").executes(ToolLevelingCommand::github))).then(Commands.m_82127_((String)"issue").executes(ToolLevelingCommand::issue))).then(Commands.m_82127_((String)"wiki").executes(ToolLevelingCommand::wiki))).then(Commands.m_82127_((String)"discord").executes(ToolLevelingCommand::discord))).then(Commands.m_82127_((String)"curseforge").executes(ToolLevelingCommand::curseforge))).then(Commands.m_82127_((String)"modrinth").executes(ToolLevelingCommand::modrinth));
        dispatcher.register(command);
    }

    private static int configReload(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ConfigManager.reloadAllConfigs();
        ResponseHelper.sendMessageConfigReload(source);
        return 1;
    }

    private static int configShow(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ConfigIdentifier config = (ConfigIdentifier)((Object)context.getArgument("identifier", ConfigIdentifier.class));
        ResponseHelper.sendMessageConfigShow(source, config);
        return 1;
    }

    private static int configReset(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ConfigIdentifier config = (ConfigIdentifier)((Object)context.getArgument("identifier", ConfigIdentifier.class));
        ConfigManager.resetOneConfig(config);
        ResponseHelper.sendMessageConfigReset(source, config);
        return 1;
    }

    private static int configInfo(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ConfigIdentifier config = (ConfigIdentifier)((Object)context.getArgument("identifier", ConfigIdentifier.class));
        ResponseHelper.sendMessageConfigGeneral(source);
        ResponseHelper.sendMessageConfigSingle(source, config);
        return 1;
    }

    private static int showScreen(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenItemValueScreenPacket());
        return 1;
    }

    private static int github(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent link = ResponseHelper.clickableLink2("https://github.com/tristankechlo/ToolLeveling");
        MutableComponent message = Component.m_237113_((String)"Check out the source code on GitHub: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)link);
        ResponseHelper.sendMessage(source, (Component)message, false);
        return 1;
    }

    private static int issue(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent link = ResponseHelper.clickableLink2("https://github.com/tristankechlo/ToolLeveling/issues");
        MutableComponent message = Component.m_237113_((String)"If you found an issue, submit it here: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)link);
        ResponseHelper.sendMessage(source, (Component)message, false);
        return 1;
    }

    private static int wiki(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent link = ResponseHelper.clickableLink2("https://github.com/tristankechlo/ToolLeveling/wiki");
        MutableComponent message = Component.m_237113_((String)"The wiki can be found here: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)link);
        ResponseHelper.sendMessage(source, (Component)message, false);
        return 1;
    }

    private static int discord(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent link = ResponseHelper.clickableLink2("https://discord.gg/bhUaWhq");
        MutableComponent message = Component.m_237113_((String)"Join the Discord here: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)link);
        ResponseHelper.sendMessage(source, (Component)message, false);
        return 1;
    }

    private static int curseforge(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent link = ResponseHelper.clickableLink2("https://curseforge.com/minecraft/mc-mods/tool-leveling-plus");
        MutableComponent message = Component.m_237113_((String)"Check out the CurseForge page here: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)link);
        ResponseHelper.sendMessage(source, (Component)message, false);
        return 1;
    }

    private static int modrinth(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent link = ResponseHelper.clickableLink2("https://modrinth.com/mod/tool-leveling");
        MutableComponent message = Component.m_237113_((String)"Check out the Modrinth page here: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)link);
        ResponseHelper.sendMessage(source, (Component)message, false);
        return 1;
    }
}

