/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.util;

import com.tristankechlo.toolleveling.ToolLeveling;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;

public final class ConfigUtils {
    public static String getModIdFromWildcard(String element) {
        if (element == null || !element.contains("*")) {
            return null;
        }
        String[] splitted = element.split(":");
        return splitted[1].equals("*") && ModList.get().isLoaded(splitted[0]) ? splitted[0] : null;
    }

    public static <T> List<T> getAllFromWildcard(String modid, IForgeRegistry<T> registry) {
        ArrayList tempValues = new ArrayList();
        try {
            registry.getValues().stream().filter(element -> Objects.requireNonNull(registry.getKey(element)).m_135827_().equals(modid)).forEach(tempValues::add);
        }
        catch (NullPointerException e) {
            ToolLeveling.LOGGER.error("Error while parsing entries from modid wildcard '{}'", (Object)modid);
        }
        return tempValues;
    }

    public static <T> TagKey<T> getTagKeyFromTag(String element, IForgeRegistry<T> registry) {
        if (element == null || !element.startsWith("#")) {
            return null;
        }
        ResourceLocation loc = ResourceLocation.m_135820_((String)element.substring(1));
        if (loc == null) {
            ToolLeveling.LOGGER.error("Error while parsing tag to ResourceLocation '{}'", (Object)element);
            return null;
        }
        try {
            return Objects.requireNonNull(registry.tags()).stream().filter(tag -> tag.getKey().f_203868_().equals((Object)loc)).map(ITag::getKey).findFirst().orElse(null);
        }
        catch (NullPointerException e) {
            ToolLeveling.LOGGER.error("Error while parsing tag '{}'", (Object)element);
            return null;
        }
    }

    public static <T> List<T> getAllFromTag(TagKey<T> tagKey, IForgeRegistry<T> registry) {
        ArrayList tempValues = new ArrayList();
        try {
            tempValues.addAll(Objects.requireNonNull(registry.tags()).getTag(tagKey).stream().toList());
        }
        catch (NullPointerException e) {
            ToolLeveling.LOGGER.error("Error while parsing entries from tag '{}'", (Object)tagKey.f_203868_());
        }
        return tempValues;
    }
}

