/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.config.values;

import com.google.gson.reflect.TypeToken;
import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.config.values.RegistryMapConfig;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemValues
extends RegistryMapConfig<Item, Long> {
    private static final Type TYPE = new TypeToken<Map<String, Long>>(){}.getType();

    public ItemValues(String identifier) {
        super(identifier, ForgeRegistries.ITEMS, ItemValues.getDefaultItemValues());
    }

    @Override
    protected boolean isKeyValid(Item item, ResourceLocation identifier) {
        if (item == null || item == Items.f_41852_) {
            ToolLeveling.LOGGER.warn("Item {} not found in registry", (Object)identifier);
            return false;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (item.isDamageable(stack)) {
            ToolLeveling.LOGGER.warn("Item {} is damageable, it not a valid item to use in the toolleveling table", (Object)identifier);
            return false;
        }
        if (item.m_8120_(stack)) {
            ToolLeveling.LOGGER.warn("Item {} is enchantable, it not a valid item to use in the toolleveling table", (Object)identifier);
            return false;
        }
        return true;
    }

    @Override
    protected boolean isValueValid(Long value) {
        return value >= 0L;
    }

    @Override
    protected Type getType() {
        return TYPE;
    }

    public static Map<Item, Long> getDefaultItemValues() {
        HashMap<Item, Long> values = new HashMap<Item, Long>();
        values.put(Items.f_42413_, 8L);
        values.put(Items.f_41835_, 30L);
        values.put(Items.f_150963_, 30L);
        values.put(Items.f_42200_, 73L);
        values.put(Items.f_150965_, 10L);
        values.put(Items.f_150966_, 10L);
        values.put(Items.f_151051_, 11L);
        values.put(Items.f_151052_, 14L);
        values.put(Items.f_151000_, 126L);
        values.put(Items.f_150996_, 99L);
        values.put(Items.f_151050_, 13L);
        values.put(Items.f_42416_, 15L);
        values.put(Items.f_41834_, 12L);
        values.put(Items.f_150964_, 12L);
        values.put(Items.f_150995_, 117L);
        values.put(Items.f_41913_, 135L);
        values.put(Items.f_42417_, 40L);
        values.put(Items.f_151053_, 35L);
        values.put(Items.f_41833_, 30L);
        values.put(Items.f_150967_, 30L);
        values.put(Items.f_150997_, 315L);
        values.put(Items.f_41912_, 360L);
        values.put(Items.f_42415_, 160L);
        values.put(Items.f_42010_, 160L);
        values.put(Items.f_150994_, 160L);
        values.put(Items.f_41959_, 1450L);
        values.put(Items.f_42418_, 200L);
        values.put(Items.f_42419_, 50L);
        values.put(Items.f_42792_, 50L);
        values.put(Items.f_42791_, 1800L);
        values.put(Items.f_42534_, 8L);
        values.put(Items.f_41853_, 120L);
        values.put(Items.f_150993_, 120L);
        values.put(Items.f_41854_, 70L);
        values.put(Items.f_42616_, 100L);
        values.put(Items.f_42107_, 800L);
        values.put(Items.f_150969_, 800L);
        values.put(Items.f_42110_, 900L);
        values.put(Items.f_42692_, 10L);
        values.put(Items.f_42154_, 40L);
        values.put(Items.f_42157_, 40L);
        values.put(Items.f_42451_, 4L);
        values.put(Items.f_41977_, 60L);
        values.put(Items.f_150968_, 60L);
        values.put(Items.f_42153_, 36L);
        values.put(Items.f_42525_, 4L);
        values.put(Items.f_42054_, 15L);
        values.put(Items.f_150998_, 11L);
        values.put(Items.f_151049_, 17L);
        values.put(Items.f_42436_, 400L);
        values.put(Items.f_42677_, 100L);
        values.put(Items.f_42546_, 100L);
        values.put(Items.f_42437_, 2500L);
        values.put(Items.f_42518_, 25L);
        values.put(Items.f_42204_, 225L);
        values.put(Items.f_42584_, 20L);
        values.put(Items.f_42585_, 30L);
        values.put(Items.f_42545_, 50L);
        values.put(Items.f_42593_, 15L);
        values.put(Items.f_42542_, 50L);
        values.put(Items.f_42586_, 200L);
        values.put(Items.f_42686_, 2500L);
        values.put(Items.f_42748_, 200L);
        values.put(Items.f_42729_, 300L);
        values.put(Items.f_42612_, 100L);
        values.put(Items.f_42104_, 2000L);
        values.put(Items.f_42683_, 2000L);
        values.put(Items.f_42108_, 140L);
        values.put(Items.f_42065_, 2500L);
        return values;
    }
}

