/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.menu;

import com.tristankechlo.toolleveling.blockentity.ToolLevelingTableBlockEntity;
import com.tristankechlo.toolleveling.init.ModRegistry;
import com.tristankechlo.toolleveling.menu.slot.EquipmentSlots;
import com.tristankechlo.toolleveling.menu.slot.OffhandSlot;
import com.tristankechlo.toolleveling.menu.slot.PaymentSlot;
import com.tristankechlo.toolleveling.menu.slot.UpgradeSlot;
import com.tristankechlo.toolleveling.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ToolLevelingTableMenu
extends AbstractContainerMenu {
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final int[][] EQUIPMENT_SLOT_POINTS = new int[][]{{197, 136}, {197, 154}, {215, 136}, {215, 154}};
    private final Container table;
    private final Level level;
    private final BlockPos pos;

    public ToolLevelingTableMenu(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv, (Container)new SimpleContainer(16), extraData.m_130135_());
    }

    public ToolLevelingTableMenu(int id, Inventory playerInv, Container container, BlockPos pos) {
        super((MenuType)ModRegistry.TLT_CONTAINER.get(), id);
        int column;
        int row;
        this.table = container;
        this.level = playerInv.f_35978_.f_19853_;
        this.pos = pos;
        this.m_38897_(new UpgradeSlot(container, 0, 44, 22));
        int startX = 8;
        int startY = 68;
        int slotSizePlus2 = 18;
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 5; ++column) {
                this.m_38897_(new PaymentSlot(container, 1 + row * 5 + column, startX + column * slotSizePlus2, startY + row * slotSizePlus2));
            }
        }
        startY = 136;
        startX = 17;
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInv, 9 + row * 9 + column, startX + column * slotSizePlus2, startY + row * slotSizePlus2));
            }
        }
        startY = 194;
        for (int column2 = 0; column2 < 9; ++column2) {
            this.m_38897_(new Slot((Container)playerInv, column2, startX + column2 * slotSizePlus2, startY));
        }
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlotType = VALID_EQUIPMENT_SLOTS[i];
            int[] p = EQUIPMENT_SLOT_POINTS[i];
            this.m_38897_(new EquipmentSlots((Container)playerInv, p[0], p[1], equipmentSlotType, playerInv.f_35978_));
        }
        this.m_38897_(new OffhandSlot((Container)playerInv, 206, 172));
    }

    public boolean m_6875_(Player playerIn) {
        return this.table.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        int slotCount = 16;
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index >= 0 && index < slotCount) {
                if (!this.m_38903_(itemstack1, slotCount, 36 + slotCount, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (((Slot)this.f_38839_.get(1)).m_5857_(itemstack1)) {
                if (!this.m_38903_(itemstack1, 1, slotCount, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (((Slot)this.f_38839_.get(0)).m_6657_() || !((Slot)this.f_38839_.get(0)).m_5857_(itemstack1)) {
                    return ItemStack.f_41583_;
                }
                ItemStack itemstack2 = itemstack1.m_41777_();
                itemstack2.m_41764_(1);
                itemstack1.m_41774_(1);
                ((Slot)this.f_38839_.get(0)).m_5852_(itemstack2);
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public long getContainerWorth() {
        long worth = 0L;
        for (int i = 1; i < 16; ++i) {
            ItemStack stack = this.table.m_8020_(i);
            worth += Utils.getStackWorth(stack);
        }
        return worth;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public long getBonusPoints() {
        BlockEntity entity = this.level.m_7702_(this.pos);
        if (entity instanceof ToolLevelingTableBlockEntity) {
            return ((ToolLevelingTableBlockEntity)entity).bonusPoints;
        }
        return 0L;
    }
}

