/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.network.packets;

import com.tristankechlo.toolleveling.ToolLeveling;
import com.tristankechlo.toolleveling.blockentity.ToolLevelingTableBlockEntity;
import com.tristankechlo.toolleveling.utils.Utils;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public final class SetEnchantmentToolLevelingTable {
    private final BlockPos pos;
    private final Enchantment enchantment;
    private final int level;

    public SetEnchantmentToolLevelingTable(BlockPos pos, Enchantment enchantment, int level) {
        this.pos = pos;
        this.enchantment = enchantment;
        this.level = level;
    }

    public static void encode(SetEnchantmentToolLevelingTable msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.pos);
        buffer.m_130085_(ForgeRegistries.ENCHANTMENTS.getKey((Object)msg.enchantment));
        buffer.writeInt(msg.level);
    }

    public static SetEnchantmentToolLevelingTable decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.m_130281_());
        int level = buffer.readInt();
        return new SetEnchantmentToolLevelingTable(pos, enchantment, level);
    }

    public static void handle(SetEnchantmentToolLevelingTable msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ToolLevelingTableBlockEntity table;
            ItemStack enchantedItem;
            Map enchantmentsMap;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                ToolLeveling.LOGGER.warn("Error while handling the request. Invalid sender.");
                return;
            }
            ServerLevel level = player.m_9236_();
            if (level == null || !level.m_46749_(msg.pos) || level.f_46443_) {
                ToolLeveling.LOGGER.warn("Error while handling the request. Invalid level.");
                return;
            }
            BlockEntity entity = level.m_7702_(msg.pos);
            if (entity != null && entity instanceof ToolLevelingTableBlockEntity && (enchantmentsMap = EnchantmentHelper.m_44831_((ItemStack)(enchantedItem = (table = (ToolLevelingTableBlockEntity)entity).getStackToEnchant().m_41777_()))).containsKey(msg.enchantment)) {
                long upgradeCost = Utils.getEnchantmentUpgradeCost(msg.enchantment, msg.level);
                boolean upgradeSuccess = false;
                upgradeSuccess = Utils.freeCreativeUpgrades((Player)player) ? true : table.decreaseInventoryWorth(upgradeCost);
                if (upgradeSuccess) {
                    enchantmentsMap.put(msg.enchantment, msg.level);
                    EnchantmentHelper.m_44865_((Map)enchantmentsMap, (ItemStack)enchantedItem);
                    table.m_6836_(0, enchantedItem);
                    table.m_6596_();
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

