/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.toolleveling.utils;

import com.google.common.collect.ImmutableMap;
import com.tristankechlo.toolleveling.config.ItemValueConfig;
import com.tristankechlo.toolleveling.config.ToolLevelingConfig;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public final class Utils {
    public static final Map<Enchantment, Integer> BREAKING_ENCHANTMENTS = ImmutableMap.builder().put((Object)Enchantments.f_44953_, (Object)84).put((Object)Enchantments.f_44960_, (Object)5).put((Object)Enchantments.f_44972_, (Object)7).put((Object)Enchantments.f_44954_, (Object)5).build();

    public static long getEnchantmentUpgradeCost(Enchantment enchantment, int level) {
        double globalModifier = (Double)ToolLevelingConfig.globalUpgradeCostMultiplier.getValue();
        double specificModifier = (Double)ToolLevelingConfig.enchantmentUpgradeCostModifier.getValue().getOrDefault((Object)enchantment, (Object)1.0);
        long minCost = (Long)ToolLevelingConfig.minimumUpgradeCost.getValue();
        return (long)Math.max((double)minCost, (0.87 * (double)level * (double)level + (double)(300 * level)) * specificModifier * globalModifier);
    }

    public static long getItemWorth(Item item) {
        if (ItemValueConfig.itemValues.getValue().containsKey((Object)item)) {
            return (Long)ItemValueConfig.itemValues.getValue().get((Object)item);
        }
        return (Long)ItemValueConfig.defaultItemWorth.getValue();
    }

    public static long getItemWorth(ItemStack stack) {
        return Utils.getItemWorth(stack.m_41720_());
    }

    public static long getStackWorth(ItemStack stack) {
        return (long)stack.m_41613_() * Utils.getItemWorth(stack);
    }

    public static boolean isEnchantmentAtCap(Enchantment enchantment, int level) {
        short globalEnchantmentCap = (Short)ToolLevelingConfig.globalEnchantmentCap.getValue();
        if (globalEnchantmentCap > 0) {
            short enchantmentCap;
            if (ToolLevelingConfig.enchantmentCaps.getValue().containsKey((Object)enchantment) && (enchantmentCap = ((Short)ToolLevelingConfig.enchantmentCaps.getValue().get((Object)enchantment)).shortValue()) < globalEnchantmentCap) {
                return level >= enchantmentCap;
            }
            return level >= globalEnchantmentCap;
        }
        if (ToolLevelingConfig.enchantmentCaps.getValue().containsKey((Object)enchantment)) {
            return level >= (Short)ToolLevelingConfig.enchantmentCaps.getValue().get((Object)enchantment);
        }
        return false;
    }

    public static boolean isEnchantmentOverMinimum(Enchantment enchantment, int level) {
        short globalEnchantmentMin = (Short)ToolLevelingConfig.globalMinimumEnchantmentLevel.getValue();
        if (globalEnchantmentMin > 0) {
            short enchantmentMin;
            if (ToolLevelingConfig.minimumEnchantmentLevels.getValue().containsKey((Object)enchantment) && (enchantmentMin = ((Short)ToolLevelingConfig.minimumEnchantmentLevels.getValue().get((Object)enchantment)).shortValue()) > globalEnchantmentMin) {
                return level >= enchantmentMin;
            }
            return level >= globalEnchantmentMin;
        }
        if (ToolLevelingConfig.minimumEnchantmentLevels.getValue().containsKey((Object)enchantment)) {
            return level >= (Short)ToolLevelingConfig.minimumEnchantmentLevels.getValue().get((Object)enchantment);
        }
        return level >= globalEnchantmentMin;
    }

    public static boolean willEnchantmentBreak(Enchantment enchantment, int level) {
        if (BREAKING_ENCHANTMENTS.containsKey(enchantment)) {
            return level >= BREAKING_ENCHANTMENTS.get(enchantment);
        }
        return false;
    }

    public static boolean freeCreativeUpgrades(Player player) {
        return ToolLevelingConfig.freeUpgradesForCreativePlayers.getValue() != false && player.m_7500_();
    }
}

