/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.corelib.death;

import de.maxhenkel.plane.corelib.item.ItemUtils;
import de.maxhenkel.plane.corelib.player.PlayerUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Death {
    private UUID id;
    private UUID playerUUID;
    private String playerName;
    private NonNullList<ItemStack> mainInventory = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> armorInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> offHandInventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> additionalItems = NonNullList.m_122779_();
    private NonNullList<ItemStack> equipment = NonNullList.m_122780_((int)EquipmentSlot.values().length, (Object)ItemStack.f_41583_);
    private long timestamp;
    private int experience;
    private double posX;
    private double posY;
    private double posZ;
    private String dimension;
    private byte model;

    private Death() {
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public NonNullList<ItemStack> getMainInventory() {
        return this.mainInventory;
    }

    public NonNullList<ItemStack> getArmorInventory() {
        return this.armorInventory;
    }

    public NonNullList<ItemStack> getOffHandInventory() {
        return this.offHandInventory;
    }

    public NonNullList<ItemStack> getAdditionalItems() {
        return this.additionalItems;
    }

    public NonNullList<ItemStack> getEquipment() {
        return this.equipment;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getExperience() {
        return this.experience;
    }

    public double getPosX() {
        return this.posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public double getPosZ() {
        return this.posZ;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public String getDimension() {
        return this.dimension;
    }

    public byte getModel() {
        return this.model;
    }

    public String toString() {
        return "Death{name=" + this.playerName + "timestamp=" + this.timestamp + "}";
    }

    public static Death fromPlayer(Player player) {
        int i;
        Death death = new Death();
        death.id = UUID.randomUUID();
        death.playerUUID = player.m_20148_();
        death.playerName = player.m_7755_().getString();
        for (i = 0; i < death.mainInventory.size(); ++i) {
            death.mainInventory.set(i, (Object)((ItemStack)player.m_150109_().f_35974_.get(i)));
        }
        for (i = 0; i < death.armorInventory.size(); ++i) {
            death.armorInventory.set(i, (Object)((ItemStack)player.m_150109_().f_35975_.get(i)));
        }
        for (i = 0; i < death.offHandInventory.size(); ++i) {
            death.offHandInventory.set(i, (Object)((ItemStack)player.m_150109_().f_35976_.get(i)));
        }
        death.equipment = NonNullList.m_122780_((int)EquipmentSlot.values().length, (Object)ItemStack.f_41583_);
        for (i = 0; i < death.equipment.size(); ++i) {
            death.equipment.set(i, (Object)player.m_6844_(EquipmentSlot.values()[i]).m_41777_());
        }
        death.timestamp = System.currentTimeMillis();
        death.experience = player.f_36078_;
        death.posX = player.m_20185_();
        death.posY = player.m_20186_();
        death.posZ = player.m_20189_();
        death.dimension = player.f_19853_.m_46472_().m_135782_().toString();
        death.model = PlayerUtils.getModel(player);
        return death;
    }

    public void processDrops(Collection<ItemEntity> items) {
        List<ItemStack> drops = items.stream().filter(Objects::nonNull).map(ItemEntity::m_32055_).filter(itemStack -> !itemStack.m_41619_()).collect(Collectors.toList());
        this.processInventory(drops, this.mainInventory);
        this.processInventory(drops, this.armorInventory);
        this.processInventory(drops, this.offHandInventory);
        this.additionalItems.addAll(drops);
    }

    private void processInventory(List<ItemStack> drops, NonNullList<ItemStack> inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack itemStack = (ItemStack)inventory.get(i);
            if (itemStack.m_41619_()) continue;
            if (drops.contains(itemStack)) {
                drops.remove(itemStack);
                continue;
            }
            inventory.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public NonNullList<ItemStack> getAllItems() {
        NonNullList items = NonNullList.m_122779_();
        items.addAll(this.filterList((List<ItemStack>)this.mainInventory));
        items.addAll(this.filterList((List<ItemStack>)this.armorInventory));
        items.addAll(this.filterList((List<ItemStack>)this.offHandInventory));
        items.addAll(this.filterList((List<ItemStack>)this.additionalItems));
        return items;
    }

    private List<ItemStack> filterList(List<ItemStack> stacks) {
        return stacks.stream().filter(itemStack -> !itemStack.m_41619_()).collect(Collectors.toList());
    }

    public static Death fromNBT(CompoundTag compound) {
        Death death = new Death();
        death.id = compound.m_128441_("IdMost") && compound.m_128441_("IdLeast") ? new UUID(compound.m_128454_("IdMost"), compound.m_128454_("IdLeast")) : (compound.m_128441_("Id") ? compound.m_128342_("Id") : UUID.randomUUID());
        death.playerUUID = compound.m_128441_("PlayerUuidMost") && compound.m_128441_("PlayerUuidLeast") ? new UUID(compound.m_128454_("PlayerUuidMost"), compound.m_128454_("PlayerUuidLeast")) : (compound.m_128441_("PlayerUuid") ? compound.m_128342_("PlayerUuid") : UUID.randomUUID());
        death.playerName = compound.m_128461_("PlayerName");
        ItemUtils.readInventory(compound, "MainInventory", death.mainInventory);
        ItemUtils.readInventory(compound, "ArmorInventory", death.armorInventory);
        ItemUtils.readInventory(compound, "OffHandInventory", death.offHandInventory);
        death.additionalItems = ItemUtils.readItemList(compound, "Items");
        ItemUtils.readItemList(compound, "Equipment", death.equipment);
        death.timestamp = compound.m_128454_("Timestamp");
        death.experience = compound.m_128451_("Experience");
        death.posX = compound.m_128459_("PosX");
        death.posY = compound.m_128459_("PosY");
        death.posZ = compound.m_128459_("PosZ");
        death.dimension = compound.m_128461_("Dimension");
        death.model = compound.m_128445_("Model");
        return death;
    }

    public CompoundTag toNBT() {
        return this.toNBT(true);
    }

    public CompoundTag toNBT(boolean withItems) {
        CompoundTag compound = new CompoundTag();
        compound.m_128362_("Id", this.id);
        compound.m_128362_("PlayerUuid", this.playerUUID);
        compound.m_128359_("PlayerName", this.playerName);
        if (withItems) {
            ItemUtils.saveInventory(compound, "MainInventory", this.mainInventory);
            ItemUtils.saveInventory(compound, "ArmorInventory", this.armorInventory);
            ItemUtils.saveInventory(compound, "OffHandInventory", this.offHandInventory);
            ItemUtils.saveItemList(compound, "Items", this.additionalItems);
        }
        ItemUtils.saveItemList(compound, "Equipment", this.equipment);
        compound.m_128356_("Timestamp", this.timestamp);
        compound.m_128405_("Experience", this.experience);
        compound.m_128347_("PosX", this.posX);
        compound.m_128347_("PosY", this.posY);
        compound.m_128347_("PosZ", this.posZ);
        compound.m_128359_("Dimension", this.dimension);
        compound.m_128344_("Model", this.model);
        return compound;
    }

    public static class Builder {
        private Death death = new Death();

        public Builder(UUID playerUUID, UUID id) {
            this.death.dimension = "";
            this.death.playerName = "";
            this.death.playerUUID = playerUUID;
            this.death.id = id;
        }

        public Death build() {
            return this.death;
        }

        public Builder id(UUID uuid) {
            this.death.id = uuid;
            return this;
        }

        public Builder playerUUID(UUID uuid) {
            this.death.playerUUID = uuid;
            return this;
        }

        public Builder playerName(String name) {
            this.death.playerName = name;
            return this;
        }

        public Builder mainInventory(NonNullList<ItemStack> list) {
            this.death.mainInventory = list;
            return this;
        }

        public Builder armorInventory(NonNullList<ItemStack> list) {
            this.death.armorInventory = list;
            return this;
        }

        public Builder offHandInventory(NonNullList<ItemStack> list) {
            this.death.offHandInventory = list;
            return this;
        }

        public Builder additionalItems(NonNullList<ItemStack> list) {
            this.death.additionalItems = list;
            return this;
        }

        public Builder equipment(NonNullList<ItemStack> list) {
            this.death.equipment = list;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.death.timestamp = timestamp;
            return this;
        }

        public Builder experience(int experience) {
            this.death.experience = experience;
            return this;
        }

        public Builder posX(double posX) {
            this.death.posX = posX;
            return this;
        }

        public Builder posY(double posY) {
            this.death.posY = posY;
            return this;
        }

        public Builder posZ(double posZ) {
            this.death.posZ = posZ;
            return this;
        }

        public Builder dimension(String dimension) {
            this.death.dimension = dimension;
            return this;
        }

        public Builder model(byte model) {
            this.death.model = model;
            return this;
        }
    }
}

