/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityPlane
extends EntityPlaneSoundBase {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(EntityPlane.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityPlane(Level world) {
        this((EntityType<?>)((EntityType)Main.PLANE_ENTITY_TYPE.get()), world);
    }

    public EntityPlane(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Type", this.getPlaneType().getTypeName());
    }

    @Override
    public float getPlayerScaleFactor() {
        return 0.8f;
    }

    @Override
    public void openGUI(Player player, boolean outside) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return EntityPlane.this.m_7755_();
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerPlane(i, EntityPlane.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        } else {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePlaneGui(player, outside));
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPlaneType(Type.fromTypeName(compound.m_128461_("Type")));
    }

    @Override
    public ResourceLocation getLootTable() {
        return new ResourceLocation("plane", "entities/plane_" + this.getPlaneType().getTypeName());
    }

    @Override
    public float getMaxFuelUsage() {
        return 15.0f;
    }

    @Override
    public int getMaxFuel() {
        return 15000;
    }

    @Override
    public double getFallSpeed() {
        return 0.1;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)0);
    }

    @Override
    public Vec3[] getPlayerOffsets() {
        return new Vec3[]{new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 0.5), new Vec3(0.0, 0.0, 0.0)};
    }

    public Type getPlaneType() {
        return Type.values()[(Integer)this.f_19804_.m_135370_(TYPE)];
    }

    public void setPlaneType(Type type) {
        this.f_19804_.m_135381_(TYPE, (Object)type.ordinal());
    }

    public static enum Type {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        WARPED("warped"),
        CRIMSON("crimson");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getTypeName() {
            return this.name;
        }

        public static Type fromTypeName(String name) {
            for (Type type : Type.values()) {
                if (!type.getTypeName().equals(name)) continue;
                return type;
            }
            return OAK;
        }
    }
}

