/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.ServerConfig;
import de.maxhenkel.plane.entity.EntityPlaneControlBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntityPlaneFuelBase
extends EntityPlaneControlBase
implements IFluidHandler {
    private static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.m_135353_(EntityPlaneFuelBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> FUEL_TYPE = SynchedEntityData.m_135353_(EntityPlaneFuelBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public EntityPlaneFuelBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public abstract float getMaxFuelUsage();

    public abstract int getMaxFuel();

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.fuelTick();
    }

    public void fuelTick() {
        if (!this.isStarted()) {
            return;
        }
        if (this.f_19853_.m_46467_() % 20L == 0L) {
            int consumeAmount = Math.max((int)Math.ceil(this.getEngineSpeed() * this.getMaxFuelUsage()), 1);
            this.setFuel(Math.max(this.getFuel() - consumeAmount, 0));
        }
    }

    @Override
    public boolean canEngineBeStarted() {
        if (this.getFuel() <= 0) {
            return false;
        }
        return super.canEngineBeStarted();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FUEL, (Object)0);
        this.f_19804_.m_135372_(FUEL_TYPE, (Object)"");
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFuel(compound.m_128451_("Fuel"));
        this.setFuelType(compound.m_128461_("FuelType"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Fuel", this.getFuel());
        Fluid fuel = this.getFuelType();
        compound.m_128359_("FuelType", fuel == null ? "" : ForgeRegistries.FLUIDS.getKey((Object)fuel).toString());
    }

    @Nullable
    public Fluid getFuelType() {
        String type = (String)this.f_19804_.m_135370_(FUEL_TYPE);
        if (type.isEmpty()) {
            return null;
        }
        return (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(type));
    }

    public void setFuelType(Fluid fluid) {
        this.setFuelType(ForgeRegistries.FLUIDS.getKey((Object)fluid).toString());
    }

    public void setFuelType(String fluid) {
        this.f_19804_.m_135381_(FUEL_TYPE, (Object)fluid);
    }

    public int getFuel() {
        return (Integer)this.f_19804_.m_135370_(FUEL);
    }

    public void setFuel(int fuel) {
        this.f_19804_.m_135381_(FUEL, (Object)fuel);
    }

    public boolean isValidFuel(FluidStack fluid) {
        return ServerConfig.validFuels.contains(fluid.getFluid());
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Fluid fluid = this.getFuelType();
        return new FluidStack(fluid == null ? Fluids.f_76191_ : fluid, this.getFuel());
    }

    public int getTankCapacity(int tank) {
        return this.getMaxFuel();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFuel(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || !this.isValidFuel(resource)) {
            return 0;
        }
        Fluid fluid = this.getFuelType();
        if (fluid != null && this.getFuel() > 0 && !resource.getFluid().equals(fluid)) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), this.getMaxFuel() - this.getFuel());
        if (action.execute()) {
            int i = this.getFuel() + amount;
            if (i > this.getMaxFuel()) {
                i = this.getMaxFuel();
            }
            this.setFuel(i);
            this.setFuelType(resource.getFluid());
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

