/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityVehicleBase
extends Entity {
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    protected float deltaRotation;

    public EntityVehicleBase(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.f_19850_ = true;
        this.f_19793_ = 0.6f;
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickLerp();
    }

    public Player getDriver() {
        List passengers = this.m_20197_();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof Player) {
            return (Player)passengers.get(0);
        }
        return null;
    }

    protected void m_20348_(Entity passenger) {
        ArrayList<Entity> p = new ArrayList<Entity>((Collection<Entity>)this.f_19823_);
        p.add(passenger);
        this.f_19823_ = ImmutableList.copyOf(p);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public abstract int getPassengerSize();

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.getPassengerSize();
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double x = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double y = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double z = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double ry = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + ry / (double)this.lerpSteps));
            this.m_146926_((float)((double)this.m_146909_() + (this.lerpXRot - (double)this.m_146909_()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.m_6034_(x, y, z);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    protected void applyOriantationsToEntity(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + f1 - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7340_(Entity entityToUpdate) {
        this.applyOriantationsToEntity(entityToUpdate);
    }

    public abstract Vec3[] getPlayerOffsets();

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        List passengers = this.m_20197_();
        if (passengers.size() > 0) {
            int i = passengers.indexOf(passenger);
            Vec3 offset = this.getPlayerOffsets()[i];
            offset = offset.m_82524_((float)(-Math.toRadians(this.m_146908_())));
            passenger.m_6034_(this.m_20185_() + offset.f_82479_, this.m_20186_() + offset.f_82480_, this.m_20189_() + offset.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
            passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
        }
        this.applyOriantationsToEntity(passenger);
    }

    public Entity m_6688_() {
        return this.getDriver();
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!player.m_6144_()) {
            if (player.m_20202_() != this && !this.f_19853_.f_46443_) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

