/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.corelib.client.obj.OBJEntityRenderer;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public abstract class AbstractPlaneModel<T extends EntityPlaneSoundBase>
extends OBJEntityRenderer<T> {
    protected AbstractPlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(T plane, float yRot, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        super.m_7392_(plane, yRot, partialTicks, matrixStack, buffer, light);
        if (plane.m_8077_()) {
            String name = this.trimName(plane.m_7770_().getString(), 0.02f, 1.0f);
            this.drawName(plane, name, matrixStack, buffer, partialTicks, yRot, light, true);
            this.drawName(plane, name, matrixStack, buffer, partialTicks, yRot, light, false);
        }
    }

    protected String trimName(String name, float textScale, float maxLength) {
        while ((float)this.m_114481_().m_92895_(name) * textScale > maxLength) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    protected void drawName(T plane, String txt, PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, float yRot, int light, boolean left) {
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-yRot));
        float xRot = ((EntityPlaneSoundBase)((Object)plane)).f_19860_ + (plane.m_146909_() - ((EntityPlaneSoundBase)((Object)plane)).f_19860_) * partialTicks;
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
        this.translateName(plane, matrixStack, left);
        int textWidth = this.m_114481_().m_92895_(txt);
        float textScale = 0.02f;
        matrixStack.m_252880_(-(textScale * (float)textWidth) / 2.0f, 0.0f, 0.0f);
        matrixStack.m_85841_(textScale, textScale, textScale);
        this.m_114481_().m_252905_(txt, 0.0f, 0.0f, 0xFFFFFF, false, matrixStack.m_85850_().m_252922_(), buffer, false, 0, light);
        matrixStack.m_85849_();
    }

    protected abstract void translateName(T var1, PoseStack var2, boolean var3);
}

