/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.corelib.client.obj.OBJModel;
import de.maxhenkel.plane.corelib.client.obj.OBJModelInstance;
import de.maxhenkel.plane.corelib.client.obj.OBJModelOptions;
import de.maxhenkel.plane.corelib.math.Rotation;
import de.maxhenkel.plane.entity.EntityPlane;
import de.maxhenkel.plane.entity.render.AbstractPlaneModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3d;

public class PlaneModel
extends AbstractPlaneModel<EntityPlane> {
    private static final List<OBJModelInstance<EntityPlane>> MODELS = Arrays.asList(new OBJModelInstance<EntityPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/wheel.obj")), new OBJModelOptions<EntityPlane>(new ResourceLocation("plane", "textures/entity/wheel.png"), new Vector3d(-0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/wheel.obj")), new OBJModelOptions<EntityPlane>(new ResourceLocation("plane", "textures/entity/wheel.png"), new Vector3d(0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/propeller.obj")), new OBJModelOptions<EntityPlane>(new ResourceLocation("textures/block/spruce_planks.png"), new Vector3d(0.0, 1.0, -1.84375), (plane, matrixStack, partialTicks) -> {
        matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-plane.getPropellerRotation(partialTicks)));
    })));
    private static final List<OBJModelInstance<EntityPlane>> OAK_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/oak_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> DARK_OAK_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/dark_oak_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> BIRCH_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/birch_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> JUNGLE_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/jungle_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> ACACIA_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/acacia_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> SPRUCE_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/spruce_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> WARPED_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/warped_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> CRIMSON_MODEL = PlaneModel.getPlaneModel(new ResourceLocation("textures/block/crimson_planks.png"));

    public PlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    @Override
    protected void translateName(EntityPlane plane, PoseStack matrixStack, boolean left) {
        if (left) {
            matrixStack.m_85837_(0.500625, -1.25, -1.0);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        } else {
            matrixStack.m_85837_(-0.500625, -1.25, -1.0);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        }
    }

    @Override
    public List<OBJModelInstance<EntityPlane>> getModels(EntityPlane entity) {
        return PlaneModel.getModelFromType(entity);
    }

    private static List<OBJModelInstance<EntityPlane>> getModelFromType(EntityPlane plane) {
        switch (plane.getPlaneType()) {
            default: {
                return OAK_MODEL;
            }
            case DARK_OAK: {
                return DARK_OAK_MODEL;
            }
            case SPRUCE: {
                return SPRUCE_MODEL;
            }
            case JUNGLE: {
                return JUNGLE_MODEL;
            }
            case BIRCH: {
                return BIRCH_MODEL;
            }
            case ACACIA: {
                return ACACIA_MODEL;
            }
            case WARPED: {
                return WARPED_MODEL;
            }
            case CRIMSON: 
        }
        return CRIMSON_MODEL;
    }

    private static List<OBJModelInstance<EntityPlane>> getPlaneModel(ResourceLocation texture) {
        ArrayList<OBJModelInstance<EntityPlane>> models = new ArrayList<OBJModelInstance<EntityPlane>>(MODELS);
        models.add(new OBJModelInstance<EntityPlane>(new OBJModel(new ResourceLocation("plane", "models/entity/plane.obj")), new OBJModelOptions<EntityPlane>(texture, new Vector3d(0.0, 0.5, 0.0), new Rotation(180.0f, Axis.f_252436_), (plane, matrixStack, partialTicks) -> matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f))));
        return models;
    }
}

