/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.plane.corelib.inventory.ScreenBase;
import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class PlaneScreen
extends ScreenBase<ContainerPlane> {
    private static final ResourceLocation CAR_GUI_TEXTURE = new ResourceLocation("plane", "textures/gui/gui_plane.png");
    private static final Component TEXT_FUEL = Component.m_237115_((String)"gui.plane.fuel");
    private static final Component TEXT_DAMAGE = Component.m_237115_((String)"gui.plane.damage");
    private static final Component TEXT_ENGINE = Component.m_237115_((String)"gui.plane.throttle");
    private Inventory playerInv;
    private EntityPlaneSoundBase plane;

    public PlaneScreen(ContainerPlane containerCar, Inventory playerInv, Component title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.plane = containerCar.getPlane();
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92877_(matrixStack, this.plane.m_7755_().m_7532_(), 7.0f, 61.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, this.playerInv.m_5446_().m_7532_(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        this.f_96547_.m_92877_(matrixStack, TEXT_FUEL.m_7532_(), 7.0f, 9.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, TEXT_DAMAGE.m_7532_(), 95.0f, 9.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, TEXT_ENGINE.m_7532_(), 7.0f, 35.0f, 0x404040);
        if (mouseX >= this.f_97735_ + 8 && mouseX < this.f_97735_ + 80 && mouseY >= this.f_97736_ + 20 && mouseY < this.f_97736_ + 30) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)"tooltip.plane.fuel", (Object[])new Object[]{String.valueOf(this.plane.getFuel())}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 96 && mouseX < this.f_97735_ + 168 && mouseY >= this.f_97736_ + 20 && mouseY < this.f_97736_ + 30) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.plane.damage", (Object[])new Object[]{String.valueOf(MathUtils.round(this.plane.getPlaneDamage(), 2))}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 8 && mouseX < this.f_97735_ + 80 && mouseY >= this.f_97736_ + 46 && mouseY < this.f_97736_ + 56) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.plane.throttle", (Object[])new Object[]{String.valueOf(Math.round(this.plane.getEngineSpeed() * 100.0f))}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.drawFuel(matrixStack, (float)this.plane.getFuel() / (float)this.plane.getMaxFuel());
        this.drawDamage(matrixStack, (100.0f - Math.min(this.plane.getPlaneDamage(), 100.0f)) / 100.0f);
        this.drawThrottle(matrixStack, this.plane.getEngineSpeed());
    }

    public void drawFuel(PoseStack matrixStack, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawThrottle(PoseStack matrixStack, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawDamage(PoseStack matrixStack, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + 96, j + 20, 176, 20, scaled, 10);
    }
}

