/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.model;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.supermartijn642.connectedglass.model.CGModelData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;

public class CGBakedModel
extends BakedModelWrapper<BakedModel> {
    private final Map<Direction, Map<Integer, List<BakedQuad>>> quadCache = new HashMap<Direction, Map<Integer, List<BakedQuad>>>();
    private final Map<Integer, List<BakedQuad>> directionlessQuadCache = new HashMap<Integer, List<BakedQuad>>();
    private final TextureAtlasSprite particleSprite;

    public CGBakedModel(BakedModel original) {
        super(original);
        for (Direction direction : Direction.values()) {
            this.quadCache.put(direction, new HashMap());
        }
        this.particleSprite = new CroppedTextureAtlasSprite(original.m_6160_());
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData modelData, RenderType renderType) {
        Map<Integer, List<BakedQuad>> cache;
        CGModelData data = modelData.has(CGModelData.MODEL_PROPERTY) ? (CGModelData)modelData.get(CGModelData.MODEL_PROPERTY) : null;
        int hashCode = data == null ? 0 : data.hashCode();
        Map<Integer, List<BakedQuad>> map = cache = side == null ? this.directionlessQuadCache : this.quadCache.get(side);
        if (!cache.containsKey(hashCode)) {
            Map<Integer, List<BakedQuad>> map2 = cache;
            synchronized (map2) {
                if (!cache.containsKey(hashCode)) {
                    cache.put(hashCode, this.remapQuads(this.originalModel.getQuads(state, side, rand, modelData, renderType), data));
                }
            }
        }
        return cache.get(hashCode);
    }

    private List<BakedQuad> remapQuads(List<BakedQuad> originalQuads, CGModelData modelData) {
        return originalQuads.stream().map(quad -> this.remapQuad((BakedQuad)quad, modelData)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected BakedQuad remapQuad(BakedQuad quad, CGModelData modelData) {
        int[] vertexData = quad.m_111303_();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        CGBakedModel.adjustVertexDataUV(vertexData, 0, 0, quad.m_173410_(), DefaultVertexFormat.f_85811_);
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static int[] adjustVertexDataUV(int[] vertexData, int newU, int newV, TextureAtlasSprite sprite, VertexFormat vertexFormat) {
        int vertexSize = vertexFormat.m_86017_();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = CGBakedModel.findUVOffset(vertexFormat) / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float width = sprite.m_118410_() - sprite.m_118409_();
            float u = ((float)newU + (Float.intBitsToFloat(vertexData[offset]) - sprite.m_118409_()) / width) * 2.0f;
            vertexData[offset] = Float.floatToRawIntBits(sprite.m_118367_((double)u));
            float height = sprite.m_118412_() - sprite.m_118411_();
            float v = ((float)newV + (Float.intBitsToFloat(vertexData[offset + 1]) - sprite.m_118411_()) / height) * 2.0f;
            vertexData[offset + 1] = Float.floatToRawIntBits(sprite.m_118393_((double)v));
        }
        return vertexData;
    }

    private static int findUVOffset(VertexFormat vertexFormat) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < vertexFormat.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.m_86023_().get(index);
            if (el.m_86048_() != VertexFormatElement.Usage.UV) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.m_86023_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a UV attribute");
        }
        if (element.m_86041_() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected UV attribute to have data type FLOAT");
        }
        if (element.m_86050_() < 4) {
            throw new RuntimeException("Expected UV attribute to have at least 4 dimensions");
        }
        return vertexFormat.getOffset(index);
    }

    public TextureAtlasSprite m_6160_() {
        return this.particleSprite;
    }

    public BakedModel applyTransform(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        super.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
        return this;
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        return List.of(this);
    }

    private static class CroppedTextureAtlasSprite
    extends TextureAtlasSprite {
        protected CroppedTextureAtlasSprite(TextureAtlasSprite original) {
            super(original.m_247685_(), new SpriteContents(original.m_245424_().m_246162_(), new FrameSize(original.m_245424_().m_246492_() / 8, original.m_245424_().m_245330_() / 8), new NativeImage(original.m_245424_().m_246492_() / 8, original.m_245424_().m_245330_() / 8, false), new AnimationMetadataSection(List.of(), original.m_245424_().m_246492_(), original.m_245424_().m_245330_(), 0, false), original.m_245424_().forgeMeta), Math.round((float)original.m_174743_() / original.m_118409_()), Math.round((float)original.m_174744_() / original.m_118411_()), original.m_174743_(), original.m_174744_());
        }
    }
}

