/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ImageRenderer
extends EntityRenderer<ImageEntity> {
    private static final ResourceLocation DEFAULT_IMAGE = new ResourceLocation("camera", "textures/images/default_image.png");
    private static final ResourceLocation EMPTY_IMAGE = new ResourceLocation("camera", "textures/images/empty_image.png");
    private static final ResourceLocation FRAME_SIDE = new ResourceLocation("camera", "textures/images/frame_side.png");
    private static final ResourceLocation FRAME_BACK = new ResourceLocation("camera", "textures/images/frame_back.png");
    private static final float THICKNESS = 0.0625f;
    public static final UUID DEFAULT_IMAGE_UUID = new UUID(0L, 0L);
    private static Minecraft mc;

    public ImageRenderer(EntityRendererProvider.Context context) {
        super(context);
        mc = Minecraft.m_91087_();
    }

    public void render(ImageEntity entity, float f1, float f2, PoseStack matrixStack, MultiBufferSource buffer1, int light) {
        int imageLight = LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)entity.getCenterPosition());
        ImageRenderer.renderImage(entity.getImageUUID().orElse(null), entity.getFacing(), entity.getFrameWidth(), entity.getFrameHeight(), matrixStack, buffer1, imageLight);
        ImageRenderer.renderBoundingBox(entity, matrixStack, buffer1);
        super.m_7392_((Entity)entity, f1, f2, matrixStack, buffer1, light);
    }

    public static void renderImage(UUID imageUUID, Direction facing, float width, float height, PoseStack matrixStack, MultiBufferSource buffer1, int light) {
        float ratioY;
        float ratioX;
        matrixStack.m_85836_();
        float imageRatio = 1.0f;
        boolean stretch = true;
        ResourceLocation resourceLocation = EMPTY_IMAGE;
        if (DEFAULT_IMAGE_UUID.equals(imageUUID)) {
            resourceLocation = DEFAULT_IMAGE;
            imageRatio = 1.5f;
            stretch = false;
        } else if (imageUUID != null) {
            ResourceLocation rl = TextureCache.instance().getImage(imageUUID);
            if (rl != null) {
                resourceLocation = rl;
                NativeImage image = TextureCache.instance().getNativeImage(imageUUID);
                imageRatio = (float)image.m_84982_() / (float)image.m_85084_();
                stretch = false;
            } else {
                resourceLocation = DEFAULT_IMAGE;
                imageRatio = 1.5f;
                stretch = false;
            }
        }
        matrixStack.m_85837_(-0.5, 0.0, -0.5);
        ImageRenderer.rotate(facing, matrixStack);
        float frameRatio = width / height;
        float ratio = imageRatio / frameRatio;
        if (stretch) {
            ratioX = 0.0f;
            ratioY = 0.0f;
        } else {
            if (ratio >= 1.0f) {
                ratioY = (1.0f - 1.0f / ratio) / 2.0f;
                ratioX = 0.0f;
            } else {
                ratioX = (1.0f - ratio) / 2.0f;
                ratioY = 0.0f;
            }
            ratioX *= width;
            ratioY *= height;
        }
        VertexConsumer builderFront = buffer1.m_6299_(RenderType.m_110452_((ResourceLocation)resourceLocation));
        ImageRenderer.vertex(builderFront, matrixStack, 0.0f + ratioX, ratioY, 0.0625f, 0.0f, 1.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, width - ratioX, ratioY, 0.0625f, 1.0f, 1.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, width - ratioX, height - ratioY, 0.0625f, 1.0f, 0.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, ratioX, height - ratioY, 0.0625f, 0.0f, 0.0f, light);
        VertexConsumer builderSide = buffer1.m_6299_(RenderType.m_110452_((ResourceLocation)FRAME_SIDE));
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 1.0f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.9375f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0625f, 0.9375f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 1.0f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 0.0f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0f, 0.0f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0625f, 0.0625f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0625f, 0.0625f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0625f, 0.0f + ratioX, 0.9375f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0625f, 1.0f - ratioX, 0.9375f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0625f, 1.0f - ratioX, 0.0625f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.0f + ratioX, 0.0625f, light);
        VertexConsumer builderBack = buffer1.m_6299_(RenderType.m_110452_((ResourceLocation)FRAME_BACK));
        ImageRenderer.vertex(builderBack, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f - ratioY, light);
        matrixStack.m_85849_();
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int light) {
        PoseStack.Pose entry = matrixStack.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        builder.m_252986_(matrix4f, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
    }

    private static void renderBoundingBox(ImageEntity entity, PoseStack matrixStack, MultiBufferSource buffer) {
        if (!(ImageRenderer.mc.f_91077_ instanceof EntityHitResult) || ((EntityHitResult)ImageRenderer.mc.f_91077_).m_82443_() != entity) {
            return;
        }
        if (ImageRenderer.mc.f_91066_.f_92062_) {
            return;
        }
        matrixStack.m_85836_();
        AABB axisalignedbb = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (AABB)axisalignedbb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        matrixStack.m_85849_();
    }

    public static void rotate(Direction facing, PoseStack matrixStack) {
        switch (facing) {
            case NORTH: {
                matrixStack.m_85837_(1.0, 0.0, 1.0);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case EAST: {
                matrixStack.m_85837_(0.0, 0.0, 1.0);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                matrixStack.m_85837_(1.0, 0.0, 0.0);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            }
        }
    }

    @Nullable
    public ResourceLocation getTextureLocation(ImageEntity entity) {
        return EMPTY_IMAGE;
    }
}

