/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.api.common.data;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.util.BlockEntityUtil;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class MachineReference
implements INBTSerializable<CompoundTag> {
    public GlobalBlockPos extractGlobalPos;
    public ResourceLocation extractRegistryName;
    public boolean extractChunkLoaded;
    public Direction extractFacing = Direction.DOWN;
    public GlobalBlockPos insertGlobalPos;
    public ResourceLocation insertRegistryName;
    public boolean insertChunkLoaded;
    public Direction insertFacing = Direction.UP;
    public String customName = null;
    protected ItemStack cachedExtractItemStack = ItemStack.f_41583_;
    protected Item cachedExtractItem = null;
    protected ItemStack cachedInsertItemStack = ItemStack.f_41583_;
    protected Item cachedInsertItem = null;

    public MachineReference() {
    }

    public MachineReference(GlobalBlockPos extractGlobalPos, ResourceLocation extractRegistryName, boolean extractChunkLoaded, GlobalBlockPos insertGlobalPos, ResourceLocation insertRegistryName, boolean insertChunkLoaded) {
        this.extractGlobalPos = extractGlobalPos;
        this.extractRegistryName = extractRegistryName;
        this.extractChunkLoaded = extractChunkLoaded;
        this.insertGlobalPos = insertGlobalPos;
        this.insertRegistryName = insertRegistryName;
        this.insertChunkLoaded = insertChunkLoaded;
    }

    public static MachineReference from(BlockEntity extractBlockEntity, BlockEntity insertBlockEntity) {
        GlobalBlockPos extractPos = GlobalBlockPos.from(extractBlockEntity);
        BlockState extractState = extractBlockEntity.m_58904_().m_8055_(extractPos.getPos());
        ItemStack extractItem = extractState.m_60734_().m_7397_((BlockGetter)extractBlockEntity.m_58904_(), extractPos.getPos(), extractState);
        boolean extractIsLoaded = extractBlockEntity.m_58904_().m_46749_(extractPos.getPos());
        GlobalBlockPos insertPos = GlobalBlockPos.from(insertBlockEntity);
        BlockState insertState = extractBlockEntity.m_58904_().m_8055_(insertPos.getPos());
        ItemStack insertItem = insertState.m_60734_().m_7397_((BlockGetter)extractBlockEntity.m_58904_(), insertPos.getPos(), insertState);
        boolean insertIsLoaded = insertBlockEntity.m_58904_().m_46749_(insertPos.getPos());
        return new MachineReference(extractPos, ForgeRegistries.ITEMS.getKey((Object)extractItem.m_41720_()), extractIsLoaded, insertPos, ForgeRegistries.ITEMS.getKey((Object)insertItem.m_41720_()), insertIsLoaded);
    }

    public static MachineReference from(CompoundTag compound) {
        MachineReference reference = new MachineReference();
        reference.deserializeNBT(compound);
        return reference;
    }

    public static MachineReference from(FriendlyByteBuf buf) {
        MachineReference reference = new MachineReference();
        reference.decode(buf);
        return reference;
    }

    public Item getExtractItem() {
        if (this.cachedExtractItem == null) {
            this.cachedExtractItem = (Item)ForgeRegistries.ITEMS.getValue(this.extractRegistryName);
        }
        return this.cachedExtractItem;
    }

    public ItemStack getExtractItemStack() {
        if (this.cachedExtractItemStack.m_41619_()) {
            this.cachedExtractItemStack = new ItemStack((ItemLike)this.getExtractItem());
        }
        return this.cachedExtractItemStack;
    }

    public Item getInsertItem() {
        if (this.cachedInsertItem == null) {
            this.cachedInsertItem = (Item)ForgeRegistries.ITEMS.getValue(this.insertRegistryName);
        }
        return this.cachedInsertItem;
    }

    public ItemStack getInsertItemStack() {
        if (this.cachedInsertItemStack.m_41619_()) {
            this.cachedInsertItemStack = new ItemStack((ItemLike)this.getInsertItem());
        }
        return this.cachedInsertItemStack;
    }

    public CompoundTag serializeNBT() {
        return this.write(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    public CompoundTag write(CompoundTag compound) {
        if (this.insertGlobalPos != null) {
            compound.m_128365_("insertGlobalPos", (Tag)this.insertGlobalPos.serializeNBT());
        }
        if (this.insertRegistryName != null) {
            compound.m_128359_("insertRegistryName", this.insertRegistryName.toString());
        }
        compound.m_128379_("insertChunkLoaded", this.insertChunkLoaded);
        compound.m_128344_("insertFacing", (byte)this.insertFacing.m_122411_());
        if (this.extractGlobalPos != null) {
            compound.m_128365_("extractGlobalPos", (Tag)this.extractGlobalPos.serializeNBT());
        }
        if (this.extractGlobalPos != null) {
            compound.m_128359_("extractGlobalPos", this.extractGlobalPos.toString());
        }
        compound.m_128379_("extractChunkLoaded", this.extractChunkLoaded);
        compound.m_128344_("extractFacing", (byte)this.extractFacing.m_122411_());
        if (!StringUtils.isBlank((CharSequence)this.customName)) {
            compound.m_128359_("customName", this.customName);
        }
        return compound;
    }

    public void read(CompoundTag compound) {
        if (compound.m_128441_("globalPos")) {
            this.insertGlobalPos = GlobalBlockPos.from(compound.m_128469_("globalPos"));
            this.extractGlobalPos = GlobalBlockPos.from(compound.m_128469_("globalPos"));
        }
        if (compound.m_128441_("registryName")) {
            this.insertRegistryName = new ResourceLocation(compound.m_128461_("registryName"));
            this.extractRegistryName = new ResourceLocation(compound.m_128461_("registryName"));
        }
        this.insertChunkLoaded = compound.m_128471_("isChunkLoaded");
        this.extractChunkLoaded = compound.m_128471_("isChunkLoaded");
        if (compound.m_128441_("insertGlobalPos")) {
            this.insertGlobalPos = GlobalBlockPos.from(compound.m_128469_("insertGlobalPos"));
        }
        if (compound.m_128441_("insertRegistryName")) {
            this.insertRegistryName = new ResourceLocation(compound.m_128461_("insertRegistryName"));
        }
        if (compound.m_128441_("insertChunkLoaded")) {
            this.insertChunkLoaded = compound.m_128471_("insertChunkLoaded");
        }
        this.insertFacing = Direction.m_122376_((int)compound.m_128451_("insertFacing"));
        if (compound.m_128441_("extractGlobalPos")) {
            this.extractGlobalPos = GlobalBlockPos.from(compound.m_128469_("extractGlobalPos"));
        }
        if (compound.m_128441_("extractRegistryName")) {
            this.extractRegistryName = new ResourceLocation(compound.m_128461_("extractRegistryName"));
        }
        if (compound.m_128441_("extractChunkLoaded")) {
            this.extractChunkLoaded = compound.m_128471_("extractChunkLoaded");
        }
        this.extractFacing = Direction.m_122376_((int)compound.m_128451_("extractFacing"));
        if (compound.m_128441_("customName")) {
            this.customName = compound.m_128461_("customName");
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.write(new CompoundTag()));
    }

    public void decode(FriendlyByteBuf buf) {
        this.deserializeNBT(buf.m_130260_());
    }

    public BlockEntity getExtractBlockEntity(Level level) {
        return BlockEntityUtil.get(level, this.extractGlobalPos);
    }

    public BlockEntity getInsertBlockEntity(Level level) {
        return BlockEntityUtil.get(level, this.insertGlobalPos);
    }

    public boolean isValidFor(Level level) {
        return this.getExtractBlockEntity(level) != null && this.getInsertBlockEntity(level) != null;
    }
}

