/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.BeholderFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.familiar.BeholderFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class BeholderFamiliarRenderer
extends MobRenderer<BeholderFamiliarEntity, BeholderFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/beholder_familiar.png");

    public BeholderFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BeholderFamiliarModel(context.m_174023_(OccultismModelLayers.FAMILIAR_BEHOLDER)), 0.3f);
        this.m_115326_(new SleepLayer((RenderLayerParent<BeholderFamiliarEntity, BeholderFamiliarModel>)this));
    }

    public void render(BeholderFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        pMatrixStack.m_252880_(0.0f, pEntity.getAnimationHeight(pPartialTicks), 0.0f);
        if (pEntity.isEating()) {
            float eatTimer = pEntity.getEatTimer(pPartialTicks);
            float scale = eatTimer < 0.8333333f ? 1.0f : Mth.m_14031_((float)((eatTimer - 0.8333333f) * 6.0f * (float)Math.PI)) + 1.0f;
            pMatrixStack.m_85841_(scale, scale, scale);
        }
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(BeholderFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class SleepLayer
    extends RenderLayer<BeholderFamiliarEntity, BeholderFamiliarModel> {
        private static final ResourceLocation SLEEP = new ResourceLocation("occultism", "textures/entity/beholder_familiar_sleep.png");

        public SleepLayer(RenderLayerParent<BeholderFamiliarEntity, BeholderFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, BeholderFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.m_20145_() || !pLivingEntity.isSitting()) {
                return;
            }
            BeholderFamiliarModel model = (BeholderFamiliarModel)this.m_117386_();
            VertexConsumer ivertexbuilder = pBuffer.m_6299_(RenderType.m_110452_((ResourceLocation)SLEEP));
            model.m_7695_(pMatrixStack, ivertexbuilder, pPackedLight, LivingEntityRenderer.m_115338_((LivingEntity)pLivingEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

