/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.CthulhuFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.familiar.CthulhuFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;

public class CthulhuFamiliarRenderer
extends MobRenderer<CthulhuFamiliarEntity, CthulhuFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/cthulhu_familiar.png");

    public CthulhuFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CthulhuFamiliarModel(context.m_174023_(OccultismModelLayers.FAMILIAR_CTHULHU)), 0.3f);
        this.m_115326_(new HeldItemLayer((RenderLayerParent<CthulhuFamiliarEntity, CthulhuFamiliarModel>)this));
    }

    public void render(CthulhuFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        if (pEntity.isPartying()) {
            float ageInTicks = (float)pEntity.f_19797_ + pPartialTicks;
            pMatrixStack.m_85837_(0.0, 1.55, 0.0);
            pMatrixStack.m_252781_(new Quaternionf().rotateXYZ(ageInTicks * 3.0f * ((float)Math.PI / 180), 0.0f, 0.0f));
            pMatrixStack.m_85837_(0.0, 0.5, 0.0);
            pEntity.f_20884_ = -180.0f;
            pEntity.f_20883_ = -180.0f;
        } else {
            pMatrixStack.m_85837_(0.0, pEntity.isSitting() ? -0.35 : (double)pEntity.getAnimationHeight(pPartialTicks) * 0.08, 0.0);
        }
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(CthulhuFamiliarEntity entity) {
        return TEXTURES;
    }

    public class HeldItemLayer
    extends RenderLayer<CthulhuFamiliarEntity, CthulhuFamiliarModel> {
        public HeldItemLayer(RenderLayerParent<CthulhuFamiliarEntity, CthulhuFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack matrixStack, MultiBufferSource pBuffer, int pPackedLight, CthulhuFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.isGiving()) {
                matrixStack.m_85836_();
                matrixStack.m_85841_(1.25f, -1.25f, 1.25f);
                matrixStack.m_85837_(0.0, -0.75, -0.35);
                matrixStack.m_252781_(new Quaternionf().rotateXYZ(-1.134464f, 0.0f, 0.0f));
                Minecraft.m_91087_().m_91290_().m_234586_().m_109322_((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.f_41940_), ItemTransforms.TransformType.GROUND, false, matrixStack, pBuffer, pPackedLight);
                matrixStack.m_85849_();
            }
        }
    }
}

