/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.blockentity;

import com.github.klikli_dev.occultism.common.blockentity.NetworkedBlockEntity;
import com.github.klikli_dev.occultism.common.container.DimensionalMineshaftContainer;
import com.github.klikli_dev.occultism.common.misc.WeightedIngredient;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class DimensionalMineshaftBlockEntity
extends NetworkedBlockEntity
implements MenuProvider {
    public static final String MAX_MINING_TIME_TAG = "maxMiningTime";
    public static final int DEFAULT_MAX_MINING_TIME = 400;
    public static int DEFAULT_ROLLS_PER_OPERATION = 1;
    public static String ROLLS_PER_OPERATION_TAG = "rollsPerOperation";
    public LazyOptional<ItemStackHandler> inputHandler = LazyOptional.of(() -> new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            DimensionalMineshaftBlockEntity.this.m_6596_();
        }
    });
    public LazyOptional<ItemStackHandler> outputHandler = LazyOptional.of(() -> new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            DimensionalMineshaftBlockEntity.this.m_6596_();
        }
    });
    public LazyOptional<CombinedInvWrapper> combinedHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.inputHandler.orElseThrow(ItemHandlerMissingException::new), (IItemHandlerModifiable)this.outputHandler.orElseThrow(ItemHandlerMissingException::new)}));
    public int miningTime;
    public int maxMiningTime = 0;
    public int rollsPerOperation = 0;
    protected Item currentInputType;
    protected List<WeightedIngredient> possibleResults;

    public DimensionalMineshaftBlockEntity(BlockPos worldPos, BlockState state) {
        super((BlockEntityType)OccultismTiles.DIMENSIONAL_MINESHAFT.get(), worldPos, state);
    }

    public static void forceInitStackNBT(ItemStack stack, ServerLevel level) {
        stack.m_41720_().m_7836_(stack, (Level)level, (Player)FakePlayerFactory.getMinecraft((ServerLevel)level));
    }

    public static int getMaxMiningTime(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0;
        }
        int time = tag.m_128451_(MAX_MINING_TIME_TAG);
        return time <= 0 ? 400 : time;
    }

    public static int getRollsPerOperation(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0;
        }
        int rolls = tag.m_128451_(ROLLS_PER_OPERATION_TAG);
        return rolls <= 0 ? DEFAULT_ROLLS_PER_OPERATION : rolls;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()).m_135815_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (direction == null) {
                return this.combinedHandler.cast();
            }
            if (direction == Direction.UP) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inputHandler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_("inputHandler")));
        this.outputHandler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_("outputHandler")));
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        this.inputHandler.ifPresent(handler -> compound.m_128365_("inputHandler", (Tag)handler.serializeNBT()));
        this.outputHandler.ifPresent(handler -> compound.m_128365_("outputHandler", (Tag)handler.serializeNBT()));
        super.m_183515_(compound);
    }

    @Override
    public void loadNetwork(CompoundTag compound) {
        super.loadNetwork(compound);
        this.miningTime = compound.m_128451_("miningTime");
        this.maxMiningTime = compound.m_128451_(MAX_MINING_TIME_TAG);
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound) {
        compound.m_128405_("miningTime", this.miningTime);
        compound.m_128405_(MAX_MINING_TIME_TAG, this.maxMiningTime);
        return super.saveNetwork(compound);
    }

    public void m_7651_() {
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
        super.m_7651_();
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            IItemHandler inputHandler = (IItemHandler)this.inputHandler.orElseThrow(ItemHandlerMissingException::new);
            ItemStack input = inputHandler.getStackInSlot(0);
            boolean dirty = false;
            if (this.miningTime > 0) {
                --this.miningTime;
                if (this.miningTime == 0 && !this.f_58857_.f_46443_) {
                    this.mine();
                }
                if (input.m_41720_() != this.currentInputType) {
                    this.miningTime = 0;
                    this.possibleResults = null;
                }
                if (this.miningTime % 10 == 0) {
                    dirty = true;
                }
            } else if (!input.m_41619_()) {
                this.currentInputType = input.m_41720_();
                DimensionalMineshaftBlockEntity.forceInitStackNBT(input, (ServerLevel)this.f_58857_);
                this.maxMiningTime = DimensionalMineshaftBlockEntity.getMaxMiningTime(input);
                this.rollsPerOperation = DimensionalMineshaftBlockEntity.getRollsPerOperation(input);
                this.miningTime = this.maxMiningTime;
                dirty = true;
            }
            if (dirty) {
                this.markNetworkDirty();
            }
        } else if (this.miningTime > 0 && this.f_58857_.m_46467_() % 10L == 0L) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)this.f_58858_.m_123342_() + 0.5, (double)((float)this.f_58858_.m_123343_() + 0.5f), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new DimensionalMineshaftContainer(id, playerInventory, this);
    }

    public void mine() {
        ItemStackHandler inputHandler = (ItemStackHandler)this.inputHandler.orElseThrow(ItemHandlerMissingException::new);
        ItemStackHandler outputHandler = (ItemStackHandler)this.outputHandler.orElseThrow(ItemHandlerMissingException::new);
        if (this.possibleResults == null) {
            List recipes = this.f_58857_.m_7465_().m_44056_((RecipeType)OccultismRecipes.MINER_TYPE.get(), (Container)new RecipeWrapper((IItemHandlerModifiable)inputHandler), this.f_58857_);
            this.possibleResults = recipes == null || recipes.size() == 0 ? new ArrayList<WeightedIngredient>() : recipes.stream().map(r -> r.getWeightedOutput()).collect(Collectors.toList());
        }
        if (this.possibleResults.size() == 0) {
            return;
        }
        for (int i = 0; i < this.rollsPerOperation; ++i) {
            Optional result = WeightedRandom.m_216822_((RandomSource)this.f_58857_.f_46441_, this.possibleResults);
            result.ifPresent(r -> ItemHandlerHelper.insertItemStacked((IItemHandler)outputHandler, (ItemStack)r.getStack().m_41777_(), (boolean)false));
        }
        ItemStack input = inputHandler.getStackInSlot(0);
        if (input.m_220157_(1, this.f_58857_.f_46441_, null)) {
            input.m_41774_(1);
            input.m_41721_(0);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
        this.combinedHandler.invalidate();
    }
}

