/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai.behaviour;

import com.github.klikli_dev.occultism.common.entity.ai.sensor.NearestTreeSensor;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class FellTreeBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final double FELL_TREE_RANGE_SQUARE = Math.pow(2.5, 2.0);
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(OccultismMemoryTypes.NEAREST_TREE.get(), (Object)MemoryStatus.VALUE_PRESENT)});
    protected int breakingTime;
    protected int previousBreakProgress;

    public FellTreeBehaviour() {
        this.runtimeProvider = entity -> 200;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        BlockPos treePos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
        double dist = entity.m_20238_(Vec3.m_82512_((Vec3i)treePos));
        return dist <= FELL_TREE_RANGE_SQUARE;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
    }

    protected void tick(E entity) {
        BlockPos treePos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
        if (NearestTreeSensor.isLog(((SpiritEntity)entity).f_19853_, treePos)) {
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(treePos));
            ++this.breakingTime;
            entity.m_6674_(InteractionHand.MAIN_HAND);
            int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
            if (this.breakingTime % 10 == 0) {
                entity.m_5496_(SoundEvents.f_12634_, 1.0f, 1.0f);
                entity.m_5496_(SoundEvents.f_12317_, 1.0f, 0.5f);
            }
            if (i != this.previousBreakProgress) {
                ((SpiritEntity)entity).f_19853_.m_6801_(entity.m_19879_(), treePos, i);
                this.previousBreakProgress = i;
            }
            if (this.breakingTime == 160) {
                entity.m_5496_(SoundEvents.f_12630_, 1.0f, 1.0f);
                this.fellTree(entity, treePos);
                BrainUtils.setMemory(entity, OccultismMemoryTypes.LAST_FELLED_TREE.get(), (Object)treePos);
                this.m_6732_((ServerLevel)entity.m_9236_(), (LivingEntity)entity, entity.m_9236_().m_46467_());
            }
        } else {
            this.m_6732_((ServerLevel)entity.m_9236_(), (LivingEntity)entity, entity.m_9236_().m_46467_());
        }
    }

    protected void start(E entity) {
        this.breakingTime = 0;
        this.previousBreakProgress = -1;
    }

    protected void stop(E entity) {
        BrainUtils.clearMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
    }

    private void fellTree(E entity, BlockPos treePos) {
        Level level = ((SpiritEntity)entity).f_19853_;
        BlockPos base = treePos;
        ArrayDeque<BlockPos> blocks = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        blocks.add(base);
        while (!blocks.isEmpty()) {
            BlockPos pos2;
            BlockPos pos = (BlockPos)blocks.remove();
            if (!visited.add(pos) || !NearestTreeSensor.isLog(level, pos)) continue;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                pos2 = pos.m_121945_(facing);
                if (visited.contains(pos2)) continue;
                blocks.add(pos2);
            }
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    pos2 = pos.m_7918_(-1 + x, 1, -1 + z);
                    if (visited.contains(pos2)) continue;
                    blocks.add(pos2);
                }
            }
            level.m_46961_(pos, true);
        }
    }
}

