/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai.behaviour;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.network.MessageSelectBlock;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class HandleUnreachableTreeBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final int FORGET_UNREACHABLE_WALK_TARGETS_AFTER_TICKS = 6000;
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.WALK_TARGET_UNREACHABLE.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.NEAREST_TREE.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    protected void start(E entity) {
        if (((Boolean)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.WALK_TARGET_UNREACHABLE.get(), () -> false)).booleanValue()) {
            Set unreachableWalkTargets = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get(), HashSet::new);
            WalkTarget walkTarget = (WalkTarget)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
            if (walkTarget != null && walkTarget.m_26420_() instanceof BlockPosTracker) {
                unreachableWalkTargets.add(walkTarget.m_26420_().m_6675_());
                BrainUtils.setForgettableMemory(entity, OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get(), (Object)unreachableWalkTargets, (int)6000);
                BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
                BrainUtils.clearMemory(entity, OccultismMemoryTypes.WALK_TARGET_UNREACHABLE.get());
                if (Occultism.DEBUG.debugAI) {
                    OccultismPackets.sendToTracking(entity, new MessageSelectBlock(walkTarget.m_26420_().m_6675_(), 50000, 0xFF0000));
                }
            }
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

