/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai.behaviour;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.ai.behaviour.FellTreeBehaviour;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.network.MessageSelectBlock;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetToTreeBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final int FORGET_UNREACHABLE_TREES_AFTER_TICKS = 6000;
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of(OccultismMemoryTypes.LAST_TREE_WALK_TARGET.get(), (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of(OccultismMemoryTypes.NEAREST_TREE.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.UNREACHABLE_TREES.get(), (Object)MemoryStatus.REGISTERED), Pair.of(OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get(), (Object)MemoryStatus.REGISTERED)});

    protected void start(E entity) {
        BlockPos treePos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
        if (entity.m_20238_(Vec3.m_82512_((Vec3i)treePos)) < FellTreeBehaviour.FELL_TREE_RANGE_SQUARE) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
            BrainUtils.clearMemory(entity, OccultismMemoryTypes.LAST_TREE_WALK_TARGET.get());
        } else {
            BlockPos walkPos = null;
            Set unreachableWalkTargets = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get(), HashSet::new);
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                BlockPos pos = treePos.m_121945_(facing);
                if (!entity.m_9236_().m_46859_(pos) || unreachableWalkTargets.contains(pos)) continue;
                walkPos = pos;
                break;
            }
            if (walkPos != null) {
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(walkPos));
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget(walkPos, 1.0f, 1));
                BrainUtils.setMemory(entity, OccultismMemoryTypes.LAST_TREE_WALK_TARGET.get(), (Object)new WalkTarget(walkPos, 1.0f, 1));
                if (Occultism.DEBUG.debugAI) {
                    OccultismPackets.sendToTracking(entity, new MessageSelectBlock(treePos, 5000, 0x800080));
                    OccultismPackets.sendToTracking(entity, new MessageSelectBlock(walkPos, 5000, 65280));
                }
            } else {
                Set unreachableTrees = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.UNREACHABLE_TREES.get(), HashSet::new);
                unreachableTrees.add(treePos);
                BrainUtils.setForgettableMemory(entity, OccultismMemoryTypes.UNREACHABLE_TREES.get(), (Object)unreachableTrees, (int)6000);
                BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
                BrainUtils.clearMemory(entity, OccultismMemoryTypes.LAST_TREE_WALK_TARGET.get());
                BrainUtils.clearMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
                if (Occultism.DEBUG.debugAI) {
                    OccultismPackets.sendToTracking(entity, new MessageSelectBlock(treePos, 50000, 0xFF0000));
                }
            }
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

