/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.familiar;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.familiar.ColoredFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.familiar.ShubNiggurathSpawnEntity;
import com.github.klikli_dev.occultism.network.MessageBeholderAttack;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class BeholderFamiliarEntity
extends ColoredFamiliarEntity {
    private static final float DEG_30 = FamiliarUtil.toRads(30.0f);
    private static final int EAT_EFFECT_DURATION = 12000;
    private final float heightOffset;
    private final Eye[] eyes = new Eye[]{new Eye(-0.13, 1.3, -0.13), new Eye(0.13999999999999999, 1.3, -0.13), new Eye(0.18000000000000002, 1.3, 0.16), new Eye(-0.09, 1.3, 0.11000000000000001)};
    private Vec2 bigEyePos;
    private Vec2 bigEyePos0 = this.bigEyeTarget = Vec2.f_82462_;
    private Vec2 bigEyeTarget;
    private int eatTimer = -1;
    private float mouthRot;
    private float actualMouthRot;
    private float actualMouthRot0;

    public BeholderFamiliarEntity(EntityType<? extends BeholderFamiliarEntity> type, Level level) {
        super((EntityType<? extends ColoredFamiliarEntity>)type, level);
        this.bigEyePos = this.bigEyeTarget;
        this.heightOffset = this.m_217043_().m_188501_() * 5.0f;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (this.m_217043_().m_188500_() >= 0.98) {
            this.tickGlow(wearer);
        }
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RayGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new EatGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            for (Eye eye : this.eyes) {
                eye.tick();
            }
            this.bigEyePos0 = new Vec2(this.bigEyePos.f_82470_, this.bigEyePos.f_82471_);
            if ((double)(Math.abs(this.bigEyePos.f_82470_ - this.bigEyeTarget.f_82470_) + Math.abs(this.bigEyePos.f_82471_ - this.bigEyeTarget.f_82471_)) < 0.05) {
                this.bigEyeTarget = new Vec2((this.m_217043_().m_188501_() - 0.5f) * 2.9f, (this.m_217043_().m_188501_() - 0.5f) * 1.9f);
            }
            this.bigEyePos = this.lerpVec(0.1f, this.bigEyePos, this.bigEyeTarget);
            this.actualMouthRot0 = this.actualMouthRot;
            this.mouthRot = Mth.m_14089_((float)((float)this.f_19797_ * 0.1f)) * FamiliarUtil.toRads(10.0f) + FamiliarUtil.toRads(27.0f);
            if (this.eatTimer != -1) {
                ++this.eatTimer;
                if (this.eatTimer == 60) {
                    this.eatTimer = -1;
                }
                if (this.eatTimer < 50) {
                    if (this.eatTimer % 5 == 0) {
                        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, SoundSource.HOSTILE, this.m_6121_(), this.m_6100_(), false);
                    }
                    this.mouthRot = Mth.m_14031_((float)this.f_19797_) * FamiliarUtil.toRads(50.0f) + FamiliarUtil.toRads(20.0f);
                }
                if (this.eatTimer == 51) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, this.m_6121_(), 0.2f, false);
                }
            }
            this.actualMouthRot = Mth.m_14179_((float)0.2f, (float)this.actualMouthRot, (float)this.mouthRot);
        } else if (this.m_217043_().m_188500_() >= 0.98) {
            this.tickGlow(this.getFamiliarOwner());
        }
        this.f_20883_ = this.f_19859_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setColor();
        this.setBeard(this.m_217043_().m_188499_());
        this.setSpikes(this.m_217043_().m_188499_());
        this.setTongue(this.m_217043_().m_188500_() < 0.1);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public float getAnimationHeight(float partialTicks) {
        if (this.isSitting()) {
            return -0.44f;
        }
        return Mth.m_14089_((float)(((float)this.f_19797_ + this.heightOffset + partialTicks) / 5.0f)) * 0.1f;
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasTongue()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    private void tickGlow(LivingEntity owner) {
        if (!this.isEffectEnabled(owner)) {
            return;
        }
        List nearby = owner.f_19853_.m_6443_(LivingEntity.class, owner.m_20191_().m_82400_(10.0), e -> !(e instanceof Player) && e != owner && e != this && !e.m_21023_(MobEffects.f_19619_));
        if (nearby.isEmpty()) {
            return;
        }
        ((LivingEntity)nearby.get(this.m_217043_().m_188503_(nearby.size()))).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 1200, 0, false, false));
    }

    public boolean hasBeard() {
        return this.hasVariant(0);
    }

    private void setBeard(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasSpikes() {
        return this.hasVariant(1);
    }

    private void setSpikes(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasTongue() {
        return this.hasVariant(2);
    }

    private void setTongue(boolean b) {
        this.setVariant(2, b);
    }

    public float getMouthRot(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.actualMouthRot0, (float)this.actualMouthRot);
    }

    public float getEatTimer(float partialTicks) {
        return ((float)this.eatTimer + partialTicks) / 60.0f;
    }

    public boolean isEating() {
        return this.eatTimer != -1;
    }

    public Vec2 getBigEyePos(float partialTicks) {
        return this.lerpVec(partialTicks, this.bigEyePos0, this.bigEyePos);
    }

    public Vec2 getEyeRot(float partialTicks, int i) {
        return this.eyes[i].getEyeRot(partialTicks);
    }

    private Vec3 lerpVec(float value, Vec3 start, Vec3 stop) {
        return new Vec3(Mth.m_14139_((double)value, (double)start.f_82479_, (double)stop.f_82479_), Mth.m_14139_((double)value, (double)start.f_82480_, (double)stop.f_82480_), Mth.m_14139_((double)value, (double)start.f_82481_, (double)stop.f_82481_));
    }

    private Vec2 lerpVec(float value, Vec2 start, Vec2 stop) {
        return new Vec2(Mth.m_14179_((float)value, (float)start.f_82470_, (float)stop.f_82470_), Mth.m_14179_((float)value, (float)start.f_82471_, (float)stop.f_82471_));
    }

    public void m_6674_(InteractionHand pHand) {
        super.m_6674_(pHand);
        this.eatTimer = 0;
    }

    public void shootRay(List<Integer> targetIds) {
        ArrayList<Eye> eyeList = new ArrayList<Eye>();
        for (Eye e : this.eyes) {
            eyeList.add(e);
        }
        Iterator<Integer> iterator = targetIds.iterator();
        while (iterator.hasNext()) {
            Eye e;
            int id = (Integer)iterator.next();
            if (eyeList.isEmpty()) break;
            int index = this.m_217043_().m_188503_(eyeList.size());
            e = (Eye)eyeList.get(index);
            eyeList.remove(index);
            e.prepareShot(id);
        }
    }

    private class Eye {
        private Vec3 lookPos0;
        private Vec3 lookPos;
        private final Vec3 pos;
        private EyeTarget eyeTarget;
        private int shotTimer;

        private Eye(double x, double y, double z) {
            this.pos = new Vec3(x, y, z);
            this.init();
        }

        public void prepareShot(int id) {
            this.shotTimer = 20;
            this.eyeTarget = new EntityEyeTarget(id);
        }

        private void init() {
            this.selectEyeTarget();
            Vec3 targetPos = this.eyeTarget.getEyeTarget();
            this.lookPos = targetPos != null ? targetPos : Vec3.f_82478_;
            this.lookPos0 = this.lookPos;
        }

        private void selectEyeTarget() {
            List entities = BeholderFamiliarEntity.this.f_19853_.m_6443_(LivingEntity.class, BeholderFamiliarEntity.this.m_20191_().m_82400_(7.0), e -> e != BeholderFamiliarEntity.this);
            this.eyeTarget = entities.isEmpty() ? new PositionEyeTarget(Vec3.f_82478_.m_82520_(5.0, 0.0, 0.0).m_82524_(BeholderFamiliarEntity.this.m_217043_().m_188501_() * 360.0f).m_82496_(BeholderFamiliarEntity.this.m_217043_().m_188501_() * 360.0f).m_82549_(BeholderFamiliarEntity.this.m_20182_())) : new EntityEyeTarget(((LivingEntity)entities.get(BeholderFamiliarEntity.this.m_217043_().m_188503_(entities.size()))).m_19879_());
        }

        private boolean needNewEyeTarget() {
            Vec3 targetPos = this.eyeTarget.getEyeTarget();
            return targetPos == null || targetPos.m_82557_(BeholderFamiliarEntity.this.m_20182_()) > 225.0 || BeholderFamiliarEntity.this.m_217043_().m_188500_() < 0.01;
        }

        private void tick() {
            Vec3 targetPos;
            this.lookPos0 = this.lookPos;
            if (this.needNewEyeTarget() && this.shotTimer == 0) {
                this.selectEyeTarget();
            }
            if ((targetPos = this.eyeTarget.getEyeTarget()) != null) {
                this.lookPos = BeholderFamiliarEntity.this.lerpVec(0.2f, this.lookPos, targetPos);
            }
            if (this.shotTimer > 0) {
                --this.shotTimer;
                if (this.shotTimer < 5) {
                    this.shoot();
                }
            }
        }

        private Vec2 getEyeRot(float partialTicks) {
            float bodyRot = FamiliarUtil.toRads(Mth.m_14189_((float)partialTicks, (float)BeholderFamiliarEntity.this.f_20884_, (float)BeholderFamiliarEntity.this.f_20883_));
            Vec3 direction = BeholderFamiliarEntity.this.m_20318_(partialTicks).m_82520_(0.0, (double)BeholderFamiliarEntity.this.getAnimationHeight(partialTicks), 0.0).m_82549_(this.pos.m_82524_(-bodyRot)).m_82505_(BeholderFamiliarEntity.this.lerpVec(partialTicks, this.lookPos0, this.lookPos));
            double yRot = Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_) + (double)FamiliarUtil.toRads(-90.0f) - (double)bodyRot;
            double xRot = direction.m_82541_().f_82480_;
            return new Vec2((float)((double)DEG_30 - (double)DEG_30 * xRot), (float)yRot);
        }

        private void shoot() {
            float bodyRot = FamiliarUtil.toRads(Mth.m_14189_((float)1.0f, (float)BeholderFamiliarEntity.this.f_20884_, (float)BeholderFamiliarEntity.this.f_20883_));
            Vec2 rot = this.getEyeRot(1.0f);
            Vec3 increment = new Vec3(0.0, 0.15, 0.0);
            Vec3 end = this.eyeTarget.getEyeTarget();
            if (end == null) {
                return;
            }
            Vec3 start = BeholderFamiliarEntity.this.m_20182_().m_82549_(new Vec3(this.pos.f_82479_, 0.9 + (double)BeholderFamiliarEntity.this.getAnimationHeight(1.0f), this.pos.f_82481_).m_82524_(-bodyRot)).m_82549_(increment);
            for (int i = 0; i < 3; ++i) {
                increment = increment.m_82496_(-rot.f_82470_);
                start = start.m_82549_(increment.m_82524_(-rot.f_82471_ - bodyRot));
            }
            Vec3 direction = start.m_82505_(end).m_82541_();
            AABB endBox = new AABB(end, end).m_82400_(0.25);
            for (int i = 0; i < 150; ++i) {
                Vec3 particlePos = start.m_82549_(direction.m_82490_((double)i * 0.1));
                BeholderFamiliarEntity.this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(BeholderFamiliarEntity.this.getRed(), BeholderFamiliarEntity.this.getBlue(), BeholderFamiliarEntity.this.getGreen()), 1.0f), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                if (endBox.m_82381_(new AABB(particlePos, particlePos).m_82400_(0.25))) break;
            }
        }

        private class EntityEyeTarget
        extends EyeTarget {
            int entityId;

            private EntityEyeTarget(int entityId) {
                this.entityId = entityId;
            }

            @Override
            protected Vec3 getEyeTarget() {
                Entity e = BeholderFamiliarEntity.this.f_19853_.m_6815_(this.entityId);
                return e == null ? null : e.m_20299_(0.0f);
            }
        }

        private abstract class EyeTarget {
            private EyeTarget() {
            }

            protected abstract Vec3 getEyeTarget();
        }

        private class PositionEyeTarget
        extends EyeTarget {
            Vec3 position;

            private PositionEyeTarget(Vec3 position) {
                this.position = position;
            }

            @Override
            protected Vec3 getEyeTarget() {
                return this.position;
            }
        }
    }

    private static class RayGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 100;
        protected final BeholderFamiliarEntity entity;
        private int cooldown = 100;
        private int attackTimer;
        private List<Integer> targetIds;

        private RayGoal(BeholderFamiliarEntity entity) {
            this.entity = entity;
        }

        public boolean m_8036_() {
            return this.entity.getFamiliarOwner() instanceof Player;
        }

        public void m_8041_() {
            this.cooldown = 100;
            this.targetIds = null;
            this.attackTimer = 0;
        }

        public void m_8037_() {
            List<Integer> enemies = this.getNearbyEnemies();
            if (this.cooldown-- < 0 && !enemies.isEmpty()) {
                this.targetIds = enemies;
                this.cooldown = 100;
                this.attackTimer = 23;
                OccultismPackets.sendToTracking((Entity)this.entity, new MessageBeholderAttack(this.entity.m_19879_(), this.targetIds));
            }
            if (this.targetIds != null && this.attackTimer-- < 0) {
                this.attack();
                this.targetIds = null;
            }
        }

        private List<Integer> getNearbyEnemies() {
            ArrayList<Integer> enemies = new ArrayList<Integer>();
            for (Entity entity : FamiliarUtil.getOwnerEnemies(this.entity.getFamiliarOwner(), (LivingEntity)this.entity, 100.0f)) {
                enemies.add(entity.m_19879_());
            }
            return enemies;
        }

        protected void attack() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.BEHOLDER_RAY);
            for (int id : this.targetIds) {
                Entity e = this.entity.f_19853_.m_6815_(id);
                float damage = 6.0f;
                if (this.entity.m_21023_(MobEffects.f_19600_)) {
                    damage *= (float)(this.entity.m_21124_(MobEffects.f_19600_).m_19564_() + 2);
                }
                if (e == null || !(owner instanceof Player)) continue;
                Player player = (Player)owner;
                e.m_6469_(DamageSource.m_19344_((Player)player), damage);
            }
        }
    }

    private static class EatGoal
    extends Goal {
        private static final int MAX_COOLDOWN = 600;
        protected final BeholderFamiliarEntity entity;
        private int cooldown;

        private EatGoal(BeholderFamiliarEntity entity) {
            this.entity = entity;
        }

        public boolean m_8036_() {
            return !this.entity.isSitting() && this.cooldown-- < 0;
        }

        public void m_8056_() {
            this.cooldown = 600;
            List foods = this.entity.f_19853_.m_6443_(ShubNiggurathSpawnEntity.class, this.entity.m_20191_().m_82400_(3.0), Entity::m_6084_);
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (!foods.isEmpty() && this.entity.isEffectEnabled(owner)) {
                Entity food = (Entity)foods.get(this.entity.m_217043_().m_188503_(foods.size()));
                food.m_142687_(Entity.RemovalReason.DISCARDED);
                this.entity.m_6674_(InteractionHand.MAIN_HAND);
                this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 12000, 0, false, false));
                this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 12000, 0, false, false));
                OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.BEHOLDER_EAT);
            }
        }

        public void m_8041_() {
            this.cooldown = 600;
        }
    }
}

