/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.job;

import com.github.klikli_dev.occultism.common.container.spirit.SpiritTransporterContainer;
import com.github.klikli_dev.occultism.common.entity.ai.goal.DepositItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.goal.PickupItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.goal.ReturnToWorkAreaGoal;
import com.github.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.util.StorageUtil;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class CleanerJob
extends SpiritJob
implements MenuProvider {
    protected PickupItemsGoal pickupItemsGoal;
    protected ReturnToWorkAreaGoal returnToWorkAreaGoal;
    protected DepositItemsGoal depositItemsGoal;

    public CleanerJob(SpiritEntity entity) {
        super(entity);
    }

    public Component m_5446_() {
        return this.entity.m_5446_();
    }

    @Override
    public void onInit() {
        this.returnToWorkAreaGoal = new ReturnToWorkAreaGoal(this.entity);
        this.entity.f_21346_.m_25352_(0, (Goal)this.returnToWorkAreaGoal);
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.f_21346_.m_25352_(1, (Goal)this.pickupItemsGoal);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.f_21345_.m_25352_(4, (Goal)this.depositItemsGoal);
    }

    @Override
    public void cleanup() {
        this.entity.f_21346_.m_25363_((Goal)this.returnToWorkAreaGoal);
        this.entity.f_21346_.m_25363_((Goal)this.pickupItemsGoal);
        this.entity.f_21345_.m_25363_((Goal)this.depositItemsGoal);
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        boolean matches = StorageUtil.matchesFilter(stack, (IItemHandler)this.entity.getFilterItems().orElseThrow(ItemHandlerMissingException::new)) || StorageUtil.matchesFilter(stack, this.entity.getTagFilter());
        boolean isBlacklist = this.entity.isFilterBlacklist();
        return !isBlacklist && matches || isBlacklist && !matches;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new SpiritTransporterContainer(id, playerInventory, this.entity);
    }
}

