/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.spirit;

import com.github.klikli_dev.occultism.registry.OccultismTags;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class AfritWildEntity
extends Monster {
    public AfritWildEntity(EntityType<? extends AfritWildEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22283_, 8.0).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.40000001192092893).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22285_, 50.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int maxBlazes = 3 + level.m_213780_().m_188503_(6);
        for (int i = 0; i < maxBlazes; ++i) {
            Blaze entity = (Blaze)EntityType.f_20551_.m_20615_((Level)level.m_6018_());
            entity.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
            double offsetX = level.m_213780_().m_188583_() * (double)(1 + level.m_213780_().m_188503_(4));
            double offsetZ = level.m_213780_().m_188583_() * (double)(1 + level.m_213780_().m_188503_(4));
            entity.m_19890_((double)this.m_146903_() + offsetX, (double)this.m_146904_() + 1.5, (double)this.m_146907_() + offsetZ, (float)level.m_213780_().m_188503_(360), 0.0f);
            level.m_7967_((Entity)entity);
        }
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{Blaze.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_19384_()) {
            return true;
        }
        TagKey<EntityType<?>> alliesTags = OccultismTags.AFRIT_ALLIES;
        if (alliesTags != null) {
            Entity trueSource = source.m_7639_();
            if (trueSource != null && trueSource.m_6095_().m_204039_(alliesTags)) {
                return true;
            }
            Entity immediateSource = source.m_7640_();
            if (immediateSource != null && immediateSource.m_6095_().m_204039_(alliesTags)) {
                return true;
            }
        }
        return super.m_6673_(source);
    }
}

