/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.crafting.recipe.ItemStackFakeInventory;
import com.github.klikli_dev.occultism.crafting.recipe.ItemStackFakeInventoryRecipe;
import com.github.klikli_dev.occultism.crafting.recipe.TieredItemStackFakeInventory;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CrushingRecipe
extends ItemStackFakeInventoryRecipe {
    public static Serializer SERIALIZER = new Serializer();
    public static int DEFAULT_CRUSHING_TIME = 200;
    protected final int crushingTime;
    protected final int minTier;
    protected final boolean ignoreCrushingMultiplier;

    public CrushingRecipe(ResourceLocation id, Ingredient input, ItemStack output, int minTier, int crushingTime, boolean ignoreCrushingMultiplier) {
        super(id, input, output);
        this.crushingTime = crushingTime;
        this.minTier = minTier;
        this.ignoreCrushingMultiplier = ignoreCrushingMultiplier;
    }

    public int getCrushingTime() {
        return this.crushingTime;
    }

    public boolean getIgnoreCrushingMultiplier() {
        return this.ignoreCrushingMultiplier;
    }

    public int getMinTier() {
        return this.minTier;
    }

    @Override
    public boolean matches(ItemStackFakeInventory inv, Level level) {
        if (inv instanceof TieredItemStackFakeInventory) {
            TieredItemStackFakeInventory tieredInv = (TieredItemStackFakeInventory)inv;
            return tieredInv.getTier() >= this.minTier && this.input.test(inv.m_8020_(0));
        }
        return this.input.test(inv.m_8020_(0));
    }

    @Override
    public ItemStack assemble(ItemStackFakeInventory inv) {
        return this.m_8043_().m_41777_();
    }

    @Override
    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Override
    public ItemStack m_8043_() {
        return this.output;
    }

    @Override
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.input});
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)OccultismRecipes.CRUSHING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CrushingRecipe> {
        public CrushingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int crushingTime = GsonHelper.m_13824_((JsonObject)json, (String)"crushing_time", (int)DEFAULT_CRUSHING_TIME);
            boolean ignoreCrushingMultiplier = GsonHelper.m_13855_((JsonObject)json, (String)"ignore_crushing_multiplier", (boolean)false);
            int minTier = GsonHelper.m_13824_((JsonObject)json, (String)"min_tier", (int)-1);
            return ItemStackFakeInventoryRecipe.SERIALIZER.read((id, input, output) -> new CrushingRecipe(id, input, output, minTier, crushingTime, ignoreCrushingMultiplier), recipeId, json);
        }

        public CrushingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int crushingTime = buffer.readInt();
            boolean ignoreCrushingMultiplier = buffer.readBoolean();
            int minTier = buffer.readInt();
            return ItemStackFakeInventoryRecipe.SERIALIZER.read((id, input, output) -> new CrushingRecipe(id, input, output, minTier, crushingTime, ignoreCrushingMultiplier), recipeId, buffer);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrushingRecipe recipe) {
            buffer.writeInt(recipe.crushingTime);
            buffer.writeBoolean(recipe.ignoreCrushingMultiplier);
            buffer.writeInt(recipe.minTier);
            ItemStackFakeInventoryRecipe.SERIALIZER.write(buffer, recipe);
        }
    }
}

