/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.common.ritual.Ritual;
import com.github.klikli_dev.occultism.common.ritual.RitualFactory;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.registry.OccultismRituals;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualRecipe
extends ShapelessRecipe {
    public static Serializer SERIALIZER = new Serializer();
    private final ResourceLocation pentacleId;
    private final ResourceLocation ritualType;
    private final ResourceLocation spiritJobType;
    private final Supplier<Ritual> ritual;
    private final ItemStack ritualDummy;
    private final Ingredient activationItem;
    private final TagKey<EntityType<?>> entityToSacrifice;
    private final EntityType<?> entityToSummon;
    private final CompoundTag entityNbt;
    private final Ingredient itemToUse;
    private final int duration;
    private final int spiritMaxAge;
    private final float durationPerIngredient;
    private final String entityToSacrificeDisplayName;
    private final String command;

    public RitualRecipe(ResourceLocation id, String group, ResourceLocation pentacleId, ResourceLocation ritualType, ItemStack ritualDummy, ItemStack result, EntityType<?> entityToSummon, CompoundTag entityNbt, Ingredient activationItem, NonNullList<Ingredient> input, int duration, int spiritMaxAge, ResourceLocation spiritJobType, TagKey<EntityType<?>> entityToSacrifice, String entityToSacrificeDisplayName, Ingredient itemToUse, String command) {
        super(id, group, CraftingBookCategory.MISC, result, input);
        this.entityToSummon = entityToSummon;
        this.entityNbt = entityNbt;
        this.pentacleId = pentacleId;
        this.ritualType = ritualType;
        this.ritual = () -> ((RitualFactory)OccultismRituals.REGISTRY.get().getValue(this.ritualType)).create(this);
        this.ritualDummy = ritualDummy;
        this.activationItem = activationItem;
        this.duration = duration;
        this.spiritMaxAge = spiritMaxAge;
        this.spiritJobType = spiritJobType;
        this.durationPerIngredient = (float)this.duration / (float)(this.m_7527_().size() + 1);
        this.entityToSacrifice = entityToSacrifice;
        this.entityToSacrificeDisplayName = entityToSacrificeDisplayName;
        this.itemToUse = itemToUse;
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public CompoundTag getEntityNbt() {
        return this.entityNbt;
    }

    public ResourceLocation getPentacleId() {
        return this.pentacleId;
    }

    public Multiblock getPentacle() {
        return ModonomiconAPI.get().getMultiblock(this.pentacleId);
    }

    public ItemStack getRitualDummy() {
        return this.ritualDummy;
    }

    public Ingredient getActivationItem() {
        return this.activationItem;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getDurationPerIngredient() {
        return this.durationPerIngredient;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_5818_(CraftingContainer pInv, Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(CraftingContainer pInv) {
        return null;
    }

    public boolean matches(Level level, BlockPos goldenBowlPosition, ItemStack activationItem) {
        return this.ritual.get().identify(level, goldenBowlPosition, activationItem);
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)OccultismRecipes.RITUAL_TYPE.get();
    }

    public TagKey<EntityType<?>> getEntityToSacrifice() {
        return this.entityToSacrifice;
    }

    public boolean requiresSacrifice() {
        return this.entityToSacrifice != null;
    }

    public Ingredient getItemToUse() {
        return this.itemToUse;
    }

    public boolean requiresItemUse() {
        return this.itemToUse != Ingredient.f_43901_;
    }

    public EntityType<?> getEntityToSummon() {
        return this.entityToSummon;
    }

    public ResourceLocation getRitualType() {
        return this.ritualType;
    }

    public Ritual getRitual() {
        return this.ritual.get();
    }

    public String getEntityToSacrificeDisplayName() {
        return this.entityToSacrificeDisplayName;
    }

    public ResourceLocation getSpiritJobType() {
        return this.spiritJobType;
    }

    public int getSpiritMaxAge() {
        return this.spiritMaxAge;
    }

    public static class Serializer
    implements RecipeSerializer<RitualRecipe> {
        private static final ShapelessRecipe.Serializer serializer = new ShapelessRecipe.Serializer();

        private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < pIngredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)pIngredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public RitualRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ResourceLocation ritualType = new ResourceLocation(json.get("ritual_type").getAsString());
            EntityType entityToSummon = null;
            if (json.has("entity_to_summon")) {
                entityToSummon = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"entity_to_summon")));
            }
            CompoundTag entityNbt = null;
            if (json.has("entity_nbt")) {
                entityNbt = CraftingHelper.getNBT((JsonElement)json.get("entity_nbt"));
            }
            JsonArray activationItemElement = GsonHelper.m_13885_((JsonObject)json, (String)"activation_item") ? GsonHelper.m_13933_((JsonObject)json, (String)"activation_item") : GsonHelper.m_13930_((JsonObject)json, (String)"activation_item");
            Ingredient activationItem = Ingredient.m_43917_((JsonElement)activationItemElement);
            ResourceLocation pentacleId = new ResourceLocation(json.get("pentacle_id").getAsString());
            int duration = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)30);
            int spiritMaxAge = GsonHelper.m_13824_((JsonObject)json, (String)"spirit_max_age", (int)-1);
            ResourceLocation spiritJobType = null;
            if (json.has("spirit_job_type")) {
                spiritJobType = new ResourceLocation(json.get("spirit_job_type").getAsString());
            }
            ItemStack ritualDummy = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"ritual_dummy"), (boolean)true);
            TagKey entityToSacrifice = null;
            String entityToSacrificeDisplayName = "";
            if (json.has("entity_to_sacrifice")) {
                ResourceLocation tagRL = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json.getAsJsonObject("entity_to_sacrifice"), (String)"tag"));
                entityToSacrifice = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagRL);
                entityToSacrificeDisplayName = json.getAsJsonObject("entity_to_sacrifice").get("display_name").getAsString();
            }
            Ingredient itemToUse = Ingredient.f_43901_;
            if (json.has("item_to_use")) {
                JsonArray itemToUseElement = GsonHelper.m_13885_((JsonObject)json, (String)"item_to_use") ? GsonHelper.m_13933_((JsonObject)json, (String)"item_to_use") : GsonHelper.m_13930_((JsonObject)json, (String)"item_to_use");
                itemToUse = Ingredient.m_43917_((JsonElement)itemToUseElement);
            }
            String command = GsonHelper.m_13851_((JsonObject)json, (String)"command", null);
            return new RitualRecipe(recipeId, group, pentacleId, ritualType, ritualDummy, result, entityToSummon, entityNbt, activationItem, ingredients, duration, spiritMaxAge, spiritJobType, entityToSacrifice, entityToSacrificeDisplayName, itemToUse, command);
        }

        public RitualRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapelessRecipe recipe = serializer.m_8005_(recipeId, buffer);
            ResourceLocation ritualType = buffer.m_130281_();
            EntityType entityToSummon = null;
            if (buffer.readBoolean()) {
                entityToSummon = (EntityType)buffer.readRegistryId();
            }
            CompoundTag entityNbt = null;
            if (buffer.readBoolean()) {
                entityNbt = buffer.m_130260_();
            }
            ResourceLocation pentacleId = buffer.m_130281_();
            int duration = buffer.m_130242_();
            int spiritMaxAge = buffer.m_130242_();
            ResourceLocation spiritJobType = null;
            if (buffer.readBoolean()) {
                spiritJobType = buffer.m_130281_();
            }
            ItemStack ritualDummy = buffer.m_130267_();
            Ingredient activationItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            TagKey entityToSacrifice = null;
            String entityToSacrificeDisplayName = "";
            if (buffer.readBoolean()) {
                ResourceLocation tagRL = buffer.m_130281_();
                entityToSacrifice = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tagRL);
                entityToSacrificeDisplayName = buffer.m_130277_();
            }
            Ingredient itemToUse = Ingredient.f_43901_;
            if (buffer.readBoolean()) {
                itemToUse = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            String command = buffer.readBoolean() ? buffer.m_130277_() : null;
            return new RitualRecipe(recipe.m_6423_(), recipe.m_6076_(), pentacleId, ritualType, ritualDummy, recipe.m_8043_(), entityToSummon, entityNbt, activationItem, (NonNullList<Ingredient>)recipe.m_7527_(), duration, spiritMaxAge, spiritJobType, entityToSacrifice, entityToSacrificeDisplayName, itemToUse, command);
        }

        public void toNetwork(FriendlyByteBuf buffer, RitualRecipe recipe) {
            serializer.m_6178_(buffer, (ShapelessRecipe)recipe);
            buffer.m_130085_(recipe.ritualType);
            buffer.writeBoolean(recipe.entityToSummon != null);
            if (recipe.entityToSummon != null) {
                buffer.writeRegistryId(ForgeRegistries.ENTITY_TYPES, recipe.entityToSummon);
            }
            buffer.writeBoolean(recipe.entityNbt != null);
            if (recipe.entityNbt != null) {
                buffer.m_130079_(recipe.entityNbt);
            }
            buffer.m_130085_(recipe.pentacleId);
            buffer.m_130130_(recipe.duration);
            buffer.m_130130_(recipe.spiritMaxAge);
            buffer.writeBoolean(recipe.spiritJobType != null);
            if (recipe.spiritJobType != null) {
                buffer.m_130085_(recipe.spiritJobType);
            }
            buffer.m_130055_(recipe.ritualDummy);
            recipe.activationItem.m_43923_(buffer);
            buffer.writeBoolean(recipe.entityToSacrifice != null);
            if (recipe.entityToSacrifice != null) {
                buffer.m_130085_(recipe.entityToSacrifice.f_203868_());
                buffer.m_130070_(recipe.entityToSacrificeDisplayName);
            }
            buffer.writeBoolean(recipe.itemToUse != Ingredient.f_43901_);
            if (recipe.itemToUse != Ingredient.f_43901_) {
                recipe.itemToUse.m_43923_(buffer);
            }
            buffer.writeBoolean(recipe.command != null);
            if (recipe.command != null) {
                buffer.m_130070_(recipe.command);
            }
        }
    }
}

