/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class SpiritTradeRecipe
extends ShapelessRecipe {
    public static Serializer SERIALIZER = new Serializer();

    public SpiritTradeRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> input) {
        super(id, group, CraftingBookCategory.MISC, result, input);
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_5818_(@Nonnull CraftingContainer inventory, @Nonnull Level level) {
        return false;
    }

    public ItemStack m_5874_(CraftingContainer inventoryCrafting) {
        return null;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)OccultismRecipes.SPIRIT_TRADE_TYPE.get();
    }

    public List<ItemStack> consume(List<ItemStack> input) {
        List<ItemStack> result = input.stream().map(ItemStack::m_41777_).collect(Collectors.toList());
        for (Ingredient ingredient : this.m_7527_()) {
            Iterator<ItemStack> it = result.iterator();
            while (it.hasNext()) {
                ItemStack stack = it.next();
                if (!ingredient.test(stack)) continue;
                stack.m_41774_(1);
                if (!stack.m_41619_()) continue;
                it.remove();
            }
        }
        return result;
    }

    public boolean isValid(ItemStack ... input) {
        return this.isValid(Arrays.asList(input));
    }

    public boolean isValid(List<ItemStack> input) {
        List cached = input.stream().map(ItemStack::m_41777_).collect(Collectors.toList());
        for (Ingredient ingredient : this.m_7527_()) {
            boolean matched = false;
            Iterator it = cached.iterator();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (!ingredient.test(stack)) continue;
                matched = true;
                stack.m_41774_(1);
                if (!stack.m_41619_()) continue;
                it.remove();
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SpiritTradeRecipe> {
        private static final ShapelessRecipe.Serializer serializer = new ShapelessRecipe.Serializer();

        public SpiritTradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe recipe = serializer.m_6729_(recipeId, json);
            return new SpiritTradeRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(), (NonNullList<Ingredient>)recipe.m_7527_());
        }

        public SpiritTradeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapelessRecipe recipe = serializer.m_8005_(recipeId, buffer);
            return new SpiritTradeRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(), (NonNullList<Ingredient>)recipe.m_7527_());
        }

        public void toNetwork(FriendlyByteBuf buffer, SpiritTradeRecipe recipe) {
            serializer.m_6178_(buffer, (ShapelessRecipe)recipe);
        }
    }
}

