/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.datagen.ItemModelsGenerator;
import com.github.klikli_dev.occultism.datagen.OccultismAdvancementProvider;
import com.github.klikli_dev.occultism.datagen.OccultismBookProvider;
import com.github.klikli_dev.occultism.datagen.PentacleProvider;
import com.github.klikli_dev.occultism.datagen.StandardBlockStateProvider;
import com.github.klikli_dev.occultism.datagen.lang.ENUSProvider;
import com.github.klikli_dev.occultism.datagen.lang.FRFRProvider;
import com.github.klikli_dev.occultism.datagen.lang.PTBRProvider;
import com.github.klikli_dev.occultism.datagen.lang.loot.OccultismBlockLoot;
import com.github.klikli_dev.occultism.datagen.lang.loot.OccultismEntityLoot;
import com.github.klikli_dev.occultism.datagen.worldgen.OccultismRegistries;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(generator.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(OccultismBlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(OccultismEntityLoot::new, LootContextParamSets.f_81415_))));
        generator.addProvider(event.includeServer(), (DataProvider)new PentacleProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismAdvancementProvider(generator));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelsGenerator(generator.getPackOutput(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new StandardBlockStateProvider(generator.getPackOutput(), event.getExistingFileHelper()));
        ENUSProvider enUSProvider = new ENUSProvider(generator.getPackOutput());
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismBookProvider(generator.getPackOutput(), "occultism", enUSProvider));
        generator.addProvider(event.includeClient(), (DataProvider)enUSProvider);
        generator.addProvider(event.includeClient(), (DataProvider)new FRFRProvider(generator.getPackOutput()));
        generator.addProvider(event.includeClient(), (DataProvider)new PTBRProvider(generator.getPackOutput()));
        CompletableFuture<HolderLookup.Provider> holderLookup = CompletableFuture.supplyAsync(OccultismRegistries::createLookup, Util.m_183991_());
        generator.addProvider(event.includeServer(), DataGenerators.bindRegistries(RegistriesDatapackGenerator::new, holderLookup));
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> datagenFactory, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        return packOutput -> (DataProvider)datagenFactory.apply(packOutput, lookupProvider);
    }
}

