/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import java.util.ArrayList;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModelsGenerator
extends ItemModelProvider {
    public ItemModelsGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "occultism", existingFileHelper);
    }

    protected void registerModels() {
        ForgeRegistries.ITEMS.forEach(item -> {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey(item);
            if (key.m_135815_().startsWith("ritual_dummy/")) {
                this.registerRitualDummy("item/" + key.m_135815_());
            }
        });
        this.registerAdvancementItem();
    }

    private void registerRitualDummy(String name) {
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("occultism:item/ritual_dummy"));
    }

    private void registerAdvancementItem() {
        String[] textures = new String[]{"cthulhu_icon", "bat_icon", "deer_icon", "devil_icon", "greedy_icon", "hat_icon", "dragon_icon", "blacksmith_icon", "guardian_icon", "headless_icon", "chimera_icon", "shub_niggurath_icon", "shub_niggurath_spawn_icon", "beholder_icon", "fairy_icon", "mummy_icon", "beaver_icon"};
        ArrayList<ItemModelBuilder> icons = new ArrayList<ItemModelBuilder>();
        for (String texture : textures) {
            icons.add((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/advancement/" + texture, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/advancement/" + texture)));
        }
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("item/advancement_icon", this.mcLoc("item/generated"));
        for (int i = 0; i < icons.size(); ++i) {
            builder.override().predicate(this.mcLoc("custom_model_data"), (float)i).model((ModelFile)icons.get(i)).end();
        }
    }
}

