/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.common.block.ChalkGlyphBlock;
import com.github.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class StandardBlockStateProvider
extends BlockStateProvider {
    public StandardBlockStateProvider(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "occultism", exFileHelper);
    }

    protected void registerStatesAndModels() {
        OccultismBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).filter(block -> block instanceof ChalkGlyphBlock).forEach(this::generateGlyphBlockState);
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller")));
        this.models().withExistingParent("item/storage_controller", this.modLoc("block/storage_controller"));
        this.simpleBlock((Block)OccultismBlocks.STORAGE_CONTROLLER_BASE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_controller_base")));
        this.models().withExistingParent("item/storage_controller_base", this.modLoc("block/storage_controller_base"));
        this.generateStableWormholeState((Block)OccultismBlocks.STABLE_WORMHOLE.get());
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER1.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier1")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER2.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier2")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER3.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier3")));
        this.directionalBlock((Block)OccultismBlocks.STORAGE_STABILIZER_TIER4.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/storage_stabilizer_tier4")));
    }

    protected void generateStableWormholeState(Block block) {
        ModelFile.ExistingModelFile linkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole"));
        ModelFile.ExistingModelFile unlinkedModel = this.models().getExistingFile(this.modLoc("block/stable_wormhole_unlinked"));
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_(StableWormholeBlock.LINKED) != false ? linkedModel : unlinkedModel)).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
        });
    }

    protected void generateGlyphBlockState(Block block) {
        ModelFile.ExistingModelFile parent = this.models().getExistingFile(this.modLoc("block/chalk_glyph/chalk_glyph"));
        this.getVariantBuilder(block).forAllStates(state -> {
            int sign = (Integer)state.m_61143_((Property)ChalkGlyphBlock.SIGN);
            ModelBuilder subModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/chalk_glyph/" + sign)).parent((ModelFile)parent)).texture("texture", this.modLoc("block/chalk_glyph/" + sign));
            return ConfiguredModel.builder().modelFile((ModelFile)subModel).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).build();
        });
    }
}

